#include "Alignment.h"

#include <QtGlobal>

using namespace stand::echoes;

bool Alignment::operator !=(const Alignment &b) const
{
    bool ret = false;
    for(int i = 0; i < _ParamNum; i++)
    {
        ret |= (_params[i] != b._params[i]);
    }
    return ret;
}

bool Alignment::operator ==(const Alignment &b) const
{
    bool ret = true;
    for(int i = 0; i < _ParamNum; i++)
    {
        ret &= (_params[i] == b._params[i]);
    }
    return ret;
}

bool Alignment::operator < (const Alignment &b) const
{
    for(int i = 0; i < _ParamNum; i++)
    {
        if(_params[i] < b._params[i])
        {
            return true;
        }
    }
    return false;
}

bool Alignment::operator <=(const Alignment &b) const
{
    for(int i = 0; i < _ParamNum; i++)
    {
        if(_params[i] <= b._params[i])
        {
            return true;
        }
    }
    return false;
}

bool Alignment::operator > (const Alignment &b) const
{
    for(int i = 0; i < _ParamNum; i++)
    {
        if(_params[i] > b._params[i])
        {
            return true;
        }
    }
    return false;
}

bool Alignment::operator >=(const Alignment &b) const
{
    for(int i = 0; i < _ParamNum; i++)
    {
        if(_params[i] >= b._params[i])
        {
            return true;
        }
    }
    return false;
}

Alignment::Alignment(const Alignment &b)
{
    (*this) = b;
}

Alignment &Alignment::operator =(const Alignment &b)
{
    for(int i = 0; i < _ParamNum; i++)
    {
        _params[i] = b._params[i];
    }
    return *this;
}

Alignment::Alignment(int noteTarget, int noteDiff, int preLength, int postLength)
{
    setNoteTarget(noteTarget);
    setNoteDiff(noteDiff);
    setPreLength(preLength);
    setPostLength(postLength);
}

Alignment::~Alignment()
{
}

void Alignment::write(FILE *fp) const
{
    int size = _ParamNum * sizeof(int);
    fwrite(&size, sizeof(int), 1, fp);
    fwrite(_params, sizeof(int), _ParamNum, fp);
}

bool Alignment::read(FILE *fp)
{
    int size, actual;
    fread(&size, sizeof(int), 1, fp);
    if(size != sizeof(int) * _ParamNum)
    {
        qWarning("stand::echoes::Alignment::read();");
        qWarning(" Error; Invalid size: %d bytes required while %d expected", size, sizeof(int) * _ParamNum);
        return false;
    }
    actual = fread(_params, sizeof(int), _ParamNum, fp);
    if(size != actual * sizeof(int))
    {
        qWarning("stand::echoes::alignmentAlignment::read();");
        qWarning(" Error; Invalid size: %d bytes read while %d required", size, sizeof(int) * _ParamNum);
        return false;
    }
    return true;
}


