#ifndef ENVELOPECOMPUTINGTASK_H
#define ENVELOPECOMPUTINGTASK_H

#include "task/Task.h"

namespace stand
{
namespace utility
{
namespace envelope
{
class Envelope;
class EnvelopeComputer;
}
}
namespace io
{
class WaveBuffer;
}
namespace gui
{
namespace helper
{

class EnvelopeComputingTask : public utility::task::Task
{
    Q_OBJECT
public:
    explicit EnvelopeComputingTask(utility::envelope::Envelope *target, const io::WaveBuffer *wave, utility::envelope::EnvelopeComputer *computer, QObject *parent = 0);
    virtual ~EnvelopeComputingTask();

    void set(utility::envelope::Envelope *target, const io::WaveBuffer *wave, utility::envelope::EnvelopeComputer *computer);
    bool exec();

private:
    void _destroy();

    utility::envelope::Envelope *_target;
    utility::envelope::EnvelopeComputer *_computer;
    const io::WaveBuffer *_wave;
};

}
}
}

#endif // ENVELOPECOMPUTINGTASK_H
