﻿#ifndef CORPUSMODEL_H
#define CORPUSMODEL_H

#include "TreeItemModel.h"
#include "xml/CorpusXmlFactory.h"

#include <QHash>

namespace stand
{
namespace model
{

class CorpusModel : public TreeItemModel
{
    Q_OBJECT
public:
    enum CorpusProperty
    {
        Name = 0,
        Version,
        Author,
        Address,
        ImagePath,
        SamplePath
    };

    explicit CorpusModel(QObject *parent = 0);
    virtual ~CorpusModel();

    virtual QString type() const
    {
        QString r = "Corpus";
        return r;
    }

    virtual const xml::TreeXmlFactory *factory() const
    {
        return &_factory;
    }

signals:

public slots:

protected:
    void onRead();
    void onDestroy();

private:
    QHash<QString, TreeItem *> _dictionary;
    static xml::CorpusXmlFactory _factory;
};

}
}

#endif // CORPUSMODEL_H
