﻿#include "PhonemeItem.h"

using namespace stand::model;

const QString PhonemeItem::Attributes[] =
{
    "alias",
    "file_path",
    "file_type",
    "left_blank",
    "length",
    "fixed_length",
    "overlap",
    "preutterance",
    "note"
};

PhonemeItem::PhonemeItem(const QString &name, TreeItem *parent) :
    TreeItem(name, parent)
{
}

void PhonemeItem::setUpDomElement(QDomDocument &doc, QDomElement &element)
{
    element.setTagName("phoneme");
    for(int i = 0; i < _NumProperties; i++)
    {
        QDomElement data = doc.createElement(Attributes[i]);
        QDomText text = doc.createTextNode(this->data(i, 0).toString());
        data.appendChild(text);
        element.appendChild(data);
    }
}

int PhonemeItem::GetColumnForString(const QString &key)
{
    for(int i = 0; i < _NumProperties; i++)
    {
        if(key == Attributes[i])
        {
            return i;
        }
    }
    return -1;
}
