#include "SequenceModel.h"
#include "ControlItem.h"
#include "TrackItem.h"
#include "EventItem.h"
#include "MeasureItem.h"


#include "Importer.h"
#include "Sequence.h"
#include "Tempo.h"
#include "Measure.h"
#include "../configure.h"

#include <QUndoStack>
#include <QStringList>

using namespace stand::model;

SequenceModel::SequenceModel(QObject *parent) :
    TreeItemModel(parent)
{
    _undoStack = NULL;
    _premeasure = 1;

    _setInitialValue();
}

SequenceModel::~SequenceModel()
{
    onDestroy();
}

void SequenceModel::onDestroy()
{
    delete _undoStack;
    _undoStack = NULL;
    _tracks.clear();
    TreeItemModel::onDestroy();
}

void SequenceModel::import(stand::sequence::importer::Importer *importer)
{
    stand::sequence::Sequence *s = new stand::sequence::Sequence(this);
    if(s->import(importer))
    {
        _setInitialValue();
        _tempo->setControl(s->tempo());
        _measure->setMeasure(s->measure());
        for(int i = 1; i < s->trackSize(); i++)
        {
            TrackItem *t = new TrackItem(QString("Track") + QString::number(i + 1), _root);
            _root->appendChild(t);
            _tracks.push_back(t);
        }
        for(int i = 0; i < s->trackSize(); i++)
        {
            _tracks[i]->setTrack(s->track(i));
        }
    }
    delete s;
    //emit dataChanged(QModelIndex(), QModelIndex());
}

void SequenceModel::_setInitialValue()
{
    onDestroy();
    _root = new TreeItem("Sequence");

    TreeItem *common, *mixer;
    TrackItem *track;
    common = new TreeItem("Common", _root);
    mixer = new TreeItem("Mixer", _root);
    _tempo = new ControlItem("Tempo", 120, _root);
    _measure = new MeasureItem("Measure", 4, 4, _root);
    track = new TrackItem("Track1", _root);

    _root->appendChild(common);
    _root->appendChild(mixer);
    _root->appendChild(_tempo);
    _root->appendChild(_measure);
    _root->appendChild(track);

    _tracks.push_back(track);

    _undoStack = new QUndoStack(this);
}

TrackItem *SequenceModel::track(int id) const
{
    if(id < 0 || id >= _tracks.size())
    {
        return NULL;
    }
    TrackItem *item = _tracks[id];
    return item;
}

int SequenceModel::minimumViewWidth(int trackId) const
{
    if(0 <= trackId && trackId < _tracks.size())
    {
        return _tracks[trackId]->length();
    }
    return 0;
}


bool SequenceModel::insertRows(int row, int count, const QModelIndex &parent)
{
    TreeItem *parentItem;
    if(!parent.isValid())
    {
        if(row < 4)
        {
            return false;
        }
        parentItem = _root;

        emit beginInsertRows(parent, row, row + count);

        for(int i = 0; i < count; i++)
        {
            TrackItem *item = new TrackItem("Track", _root);
            _tracks.push_back(item);
            _root->insertRow(row + i, item);
        }

        emit endInsertRows();
    }
    else
    {
        parentItem = static_cast<TreeItem *>(parent.internalPointer());
        if(!parentItem || parentItem->name() != "Events")
        {
            return false;
        }

        emit beginInsertRows(parent, row, row + count);

        for(int i = 0; i < count; i++)
        {
            EventItem *item = new EventItem("Track", parentItem);
            parentItem->insertRow(row + i, item);
        }

        emit endInsertRows();
    }
    return true;
}

bool SequenceModel::removeRows(int row, int count, const QModelIndex &parent)
{
    TreeItem *parentItem;
    if(!parent.isValid())
    {
        if(row < 4)
        {
            return false;
        }
        parentItem = _root;
    }
    else
    {
        parentItem = static_cast<TreeItem *>(parent.internalPointer());
        if(!parentItem || parentItem->name() != "Events")
        {
            return false;
        }
    }

    emit beginRemoveRows(parent, row, row + count);

    for(int i = 0; i < count; i++)
    {
        parentItem->removeRow(row);
    }

    emit endRemoveRows();

    return true;
}

bool SequenceModel::insertColumns(int column, int count, const QModelIndex &parent)
{
    TreeItem *item = static_cast<TreeItem *>(parent.internalPointer());
    ControlItem *control = dynamic_cast<ControlItem *>(item);
    if(!control)
    {
        return false;
    }
    emit beginInsertColumns(parent, column, column + count);
    // 何もしなくていい
    emit endInsertColumns();

    return true;
}

bool SequenceModel::removeColumns(int column, int count, const QModelIndex &parent)
{
    TreeItem *item = static_cast<TreeItem *>(parent.internalPointer());
    ControlItem *control = dynamic_cast<ControlItem *>(item);
    if(!control)
    {
        return false;
    }
    emit beginRemoveColumns(parent, column, column + count);

    control->removeColumn(column, column + count);

    emit endRemoveColumns();
    return true;
}

bool SequenceModel::insertRow(int row, const QModelIndex &parent)
{
    return insertRows(row, 1, parent);
}

bool SequenceModel::removeRow(int row, const QModelIndex &parent)
{
    return removeRows(row, 1, parent);
}

bool SequenceModel::insertColumn(int column, const QModelIndex &parent)
{
    return insertColumns(column, 1, parent);
}

bool SequenceModel::removeColumn(int column, const QModelIndex &parent)
{
    return removeColumns(column, 1, parent);
}

void SequenceModel::onRead()
{
    TreeItem *common = _root->findChildItem("Common");
    TreeItem *mixer = _root->findChildItem("Mixer");

    _tempo = dynamic_cast<ControlItem *>(_root->findChildItem("Tempo"));
    _measure = dynamic_cast<MeasureItem *>(_root->findChildItem("Measure"));

    if(!common || !mixer || !_tempo || !_measure)
    {
        _setInitialValue();
        return;
    }
    _tracks.clear();
    for(int i = 4; i < _root->childCount(); i++)
    {
        QString key = "Track" + QString::number(i - 3);
        TrackItem *track = dynamic_cast<TrackItem *>(_root->findChildItem(key));
        if(track)
        {
            _tracks.push_back(track);
        }
        else
        {
            _setInitialValue();
            return;
        }
    }
    while(_root->child(0))
    {
        _root->removeRow(0);
    }
    _root->appendChild(common);
    _root->appendChild(mixer);
    _root->appendChild(_tempo);
    _root->appendChild(_measure);
    for(int i = 0; i < _tracks.size(); i++)
    {
        _root->appendChild(_tracks[i]);
    }

    _undoStack = new QUndoStack(this);
}
