/*!
 * @file SequenceModel.h
 * @brief now writing...
 *        Data structure is below.
 * ---------+--root
 *          |
 * (row=0)  +--+--Master--(QString Key)
 *          |  +-----("Title",   String)
 *          |  +-----("Author",  String)
 *          |  +-----("Version", String)
 *          |
 * (row=1)  +--+--Mixer--(QString Key)
 *          |  +-----(int FederId, int Volume, int Panpot)
 *          |  +-----(int FederId, int Volume, int Panpot)
 *          |  +...
 *          |
 * (row=2)  +--+--Tempo--(QString Key)
 *          |  +--Data--(int tick, double value)--(int tick, double value)--...
 *          |
 * (row=3)  +--+--Measure--(QString Key)
 *          |  +--Data--(int tick, int val1, int val2)--(int tick, int val1, int val2)--...
 *          |
 * (row=4)  +--+--Track--(QString Key)
 *          |  +-----F0
 *          |  +-----Volume
 *          |  +--+--Events
 *          |     +--Data--(int tick, int length, unsigned char note)
 *          |     +--Data--(int tick, int length, unsigned char note)
 *          |     +--Data--(int tick, int length, unsigned char note)
 *          |     +--Data--(int tick, int length, unsigned char note)
 *          |
 *          +...
 */
#ifndef SEQUENCEMODEL_H
#define SEQUENCEMODEL_H

#include "TreeItemModel.h"
#include "xml/SequenceXmlFactory.h"

class QUndoStack;

namespace stand
{
namespace sequence
{
namespace importer
{
class Importer;
}
}
namespace view
{
class ViewSettings;
}
namespace model
{

class TreeItem;
class TrackItem;
class MeasureItem;
class ControlItem;

class SequenceModel : public TreeItemModel
{
    Q_OBJECT
public:
    explicit SequenceModel(QObject *parent = 0);
    virtual ~SequenceModel();

    bool insertRows(int row, int count, const QModelIndex &parent);
    bool removeRows(int row, int count, const QModelIndex &parent);
    bool insertRow(int row, const QModelIndex &parent);
    bool removeRow(int row, const QModelIndex &parent);

    bool insertColumns(int column, int count, const QModelIndex &parent);
    bool removeColumns(int column, int count, const QModelIndex &parent);

    bool insertColumn(int column, const QModelIndex &parent);
    bool removeColumn(int column, const QModelIndex &parent);

    TrackItem *track(int id) const;
    inline QUndoStack *undoStack()
    {
        return _undoStack;
    }

    inline ControlItem *tempo()
    {
        return _tempo;
    }

    inline MeasureItem *measure()
    {
        return _measure;
    }

    int premeasure() const
    {
        return _premeasure;
    }

    int minimumViewWidth(int trackId) const;

    void import(stand::sequence::importer::Importer *importer);

    virtual QString type() const
    {
        QString ret = "SequenceModel";
        return ret;
    }

    virtual const xml::TreeXmlFactory *factory() const
    {
        return &_factory;
    }

signals:

public slots:

protected:
    virtual void onRead();

private:
    virtual void onDestroy();
    void _setInitialValue();
    QList<TrackItem *> _tracks;
    ControlItem *_tempo;
    MeasureItem *_measure;
    QUndoStack *_undoStack;

    int _premeasure;
    xml::SequenceXmlFactory _factory;
};

}
}


#endif // SEQUENCEMODEL_H
