﻿#ifndef TREEITEMMODEL_H
#define TREEITEMMODEL_H

#include <QAbstractItemModel>
#include "xml/TreeXmlFactory.h"
#include "importer/Importer.h"

namespace stand
{
namespace model
{

class TreeItem;

class TreeItemModel : public QAbstractItemModel

{
    Q_OBJECT
public:
    explicit TreeItemModel(QObject *parent = 0);
    virtual ~TreeItemModel();

    virtual QVariant data(const QModelIndex &index, int role) const;
    virtual Qt::ItemFlags flags(const QModelIndex &index) const;
    virtual QVariant headerData(int section, Qt::Orientation orientation, int role = Qt::DisplayRole) const;
    virtual QModelIndex index(int row, int column, const QModelIndex &parent = QModelIndex()) const;
    virtual QModelIndex parent(const QModelIndex &index) const;
    virtual int rowCount(const QModelIndex &parent = QModelIndex()) const;
    virtual int columnCount(const QModelIndex &parent = QModelIndex()) const;
    virtual bool setData(const QModelIndex &index, const QVariant &value, int role);

    inline TreeItem *root()
    {
        return _root;
    }

    virtual bool write(const QString &path) const;
    virtual bool read(const QString &path);
    virtual bool import(const QString &path, importer::Importer *importer);
    virtual QString type() const
    {
        QString t = "TreeModel";
        return t;
    }

    virtual const xml::TreeXmlFactory *factory() const
    {
        return &_factory;
    }


signals:
    void readDone();

public slots:

protected:
    virtual void onRead(){ }
    virtual void onDestroy();
    TreeItem *_root;

private:
    static xml::TreeXmlFactory _factory;
};

}
}

#endif // TREEITEMMODEL_H
