﻿#include "Measure.h"

#include <QStringList>

using namespace stand::sequence;

Measure::Measure()
{
    clear();
}

Measure::~Measure()
{
}

const Measure::Beat &Measure::at(int tick) const
{
    for(int i = 0; i < _data.size(); i++)
    {
        if(_data[i].beginTick >= tick)
        {
            return _data[i];
        }
    }
    return _data[_data.size() - 1];
}

importer::Interpreter *Measure::interpret(const QString &line)
{
    QStringList sl = line.split(" ", QString::SkipEmptyParts);
    if(sl.size() != 4 || sl.at(0) != "Beat")
    {
        return NULL;
    }
    int tick = sl.at(1).toInt(), up = sl.at(2).toInt(), down = sl.at(3).toInt();
    _add(tick, up, down);
    return NULL;
}

const QString Measure::toString() const
{
    if(empty())
    {
        return "";
    }
    QString s;
    int tick = _data[0].endTick;
    for(int i = 1; i < _data.size(); i++)
    {
        int u = _data[i].up;
        int d = _data[i].down;
        s = name() + " Beat " + QString::number(tick) + " " + QString::number(u) + " " + QString::number(d) + "\n";
        tick = _data[i].endTick;
    }
    return s;
}

void Measure::_add(int tick, int up, int down)
{
    for(int i = 1; i < _data.size(); i++)
    {
        if(tick <= _data[i].beginTick)
        {
            Beat b = {tick, _data[i].endTick, up, down};
            _data[i].endTick = tick;
            _data.insert(i, b);
            return;
        }
    }
    Beat b = {tick, INT_MAX, up, down};
    _data.push_back(b);
    _data[_data.size() - 1].endTick = tick;
}
