#include "NoteEvent.h"

#include "AbstractHandle.h"
#include "LyricHandle.h"

#include <QStringList>

using namespace stand::sequence;

QHash<QString, importer::Interpreter *(NoteEvent::*)(const QString &)> NoteEvent::Factories;

NoteEvent::NoteEvent(Track *parent, int tick) :
    AbstractEvent(parent, tick)
{
    if(Factories.empty())
    {
        Factories["Note"] = &NoteEvent::_setNote;
        Factories["Length"] = &NoteEvent::_setLength;
        Factories["Velocity"] = &NoteEvent::_setVelocity;
        Factories["Tick"] = &NoteEvent::_setTick;
        Factories["Lyric"] = &NoteEvent::_createLyric;
        Factories["Vibrato"] = &NoteEvent::_createVibrato;
    }
    _lyric = NULL;
    _vibrato = NULL;
}

NoteEvent::~NoteEvent()
{
    delete _lyric;
    delete _vibrato;
}

const QString NoteEvent::toString() const
{
    QString retval;

    retval  = name() + " Velocity " + QString::number(_velocity) + "\n";
    retval += name() + " Length " + QString::number(_length) + "\n";
    retval += name() + " Note " + QString::number(_note) + "\n";

    if(_lyric)
    {
        retval += name() + " Lyric " + _lyric->name() + "\n";
        retval += _lyric->toString();
    }
    if(_vibrato)
    {
        retval += name() + " Vibrato " + _vibrato->name() + "\n";
    }

    return retval;
}

const QString NoteEvent::lyricForLabel() const
{
    if(!_lyric)
    {
        return "";
    }
    QString retval;
    retval = _lyric->lyric() + " [" + _lyric->pronounce() + "]";
    return retval;
}

const QString NoteEvent::lyric() const
{
    if(!_lyric)
    {
        return "";
    }
    return _lyric->lyric();
}

const QString NoteEvent::pronounce() const
{
    if(!_lyric)
    {
        return "";
    }
    return _lyric->pronounce();
}

void NoteEvent::setLyric(const QString &l)
{
    if(!_lyric)
    {
        _lyric = new LyricHandle();
        _lyric->setName(name() + "Lyric");
    }
    _lyric->setLyric(l);
}

importer::Interpreter *NoteEvent::interpret(const QString &line)
{
    Interpreter *p = NULL;
    QStringList sl = line.split(" ", QString::SkipEmptyParts);
    if(sl.size() != 2)
    {
        return NULL;
    }
    if(Factories.contains(sl.at(0)))
    {
        p = (this->*Factories[sl.at(0)])(sl.at(1));
    }
    else
    {
        qDebug("Error; NoteEvent::interpret(%s); // undefined symbol", line.toUtf8().data());
        qDebug("     ; name = %s ", name().toUtf8().data());
    }
    return p;
}

importer::Interpreter *NoteEvent::_setLength(const QString &val)
{
    _length = val.toInt();
    return NULL;
}

importer::Interpreter *NoteEvent::_setNote(const QString &val)
{
    _note = val.toInt();
    return NULL;
}

importer::Interpreter *NoteEvent::_setVelocity(const QString &val)
{
    _velocity = val.toInt();
    return NULL;
}

importer::Interpreter *NoteEvent::_setTick(const QString &val)
{
    _tick = val.toInt();
    return NULL;
}

importer::Interpreter *NoteEvent::_createLyric(const QString &name)
{
    _lyric = new LyricHandle();
    _lyric->setName(name);
    return _lyric;
}

importer::Interpreter *NoteEvent::_createVibrato(const QString &name)
{
    return NULL;
}

