#ifndef NOTEEVENT_H
#define NOTEEVENT_H

#include "AbstractEvent.h"

#include <QHash>

namespace stand
{
namespace sequence
{

class AbstractHandle;
class LyricHandle;

class NoteEvent : public AbstractEvent
{
public:
    explicit NoteEvent(Track *parent, int tick);
    virtual ~NoteEvent();

    virtual Interpreter* interpret(const QString &line);

    const QString toString() const;

    inline unsigned char note() const
    {
        return _note;
    }

    inline void setNote(unsigned char note)
    {
        _note = note;
    }

    inline int length() const
    {
        return _length;
    }

    inline void setLength(int l)
    {
        _length = l;
    }

    inline const unsigned char velocity() const
    {
        return _velocity;
    }

    inline void setVelocity(unsigned char velocity)
    {
        _velocity = velocity;
    }

    const QString lyric() const;
    void setLyric(const QString &l);
    const QString pronounce() const;

    const QString lyricForLabel() const;

private:
    Interpreter *_setLength(const QString &val);
    Interpreter *_setNote(const QString &val);
    Interpreter *_setVelocity(const QString &val);
    Interpreter *_setTick(const QString &val);
    Interpreter *_createVibrato(const QString &name);
    Interpreter *_createLyric(const QString &name);

    unsigned char _note;
    unsigned char _velocity;
    int _length;

    static QHash<QString, Interpreter *(NoteEvent::*)(const QString &)> Factories;

    LyricHandle *_lyric;
    AbstractHandle *_vibrato;
};

}
}

#endif // NOTEEVENT_H
