#include "SingerEvent.h"

#include <QStringList>

using namespace stand::sequence;

SingerEvent::SingerEvent(Track *parent, int tick) :
    AbstractEvent(parent, tick)
{
    _icon = NULL;
}

SingerEvent::~SingerEvent()
{
    delete _icon;
}

importer::Interpreter *SingerEvent::interpret(const QString &line)
{
    QStringList sl = line.split(" ", QString::SkipEmptyParts);

    if(sl.size() != 2)
    {
        return NULL;
    }

    if(sl.at(0).compare("ID") == 0)
    {
        _id = sl.at(1);
    }
    else if(sl.at(0).compare("Path") == 0)
    {
        _path = sl.at(1);
    }
    if(sl.at(0).compare("Icon") == 0)
    {
        delete _icon;
        // new IconHandle();
        //return _icon;
    }

    return NULL;
}

const QString SingerEvent::toString() const
{
    QString retval;
    retval  = name() + " ID " + _id + "\n";
    retval += name() + " Path " + _path + "\n";
    if(_icon)
    {
        //retval += name() + " Icon " + _icon->name() + "\n";
    }
    return retval;
}

