#ifndef SINGEREVENT_H
#define SINGEREVENT_H

#include "AbstractEvent.h"

#include <QString>

namespace stand
{
namespace sequence
{

class IconHandle;

class SingerEvent : public AbstractEvent
{
public:
    explicit SingerEvent(Track *parent, int tick);
    virtual ~SingerEvent();

    virtual Interpreter* interpret(const QString &line);

    const QString toString() const;

    inline QString id() const
    {
        return _id;
    }

    inline QString path() const
    {
        return _path;
    }

private:
    Interpreter *_setId(const QString &n);
    Interpreter *_setPath(const QString &n);

    IconHandle *_icon;

    QString _id;
    QString _path;
};

}
}

#endif // SINGEREVENT_H
