#ifndef SEQUENCE_INTERPRETER_H
#define SEQUENCE_INTERPRETER_H

#include <QString>

namespace stand
{
namespace sequence
{
namespace importer
{

class Interpreter
{
public:
    virtual ~Interpreter()
    {
    }

    /*!
     *  @brief 一行分の文字列を解釈します．
     *  @param[in] line 解釈する文字列．
     *  @return 解釈したオブジェクトへのポインタ．
     *  @retval NULL 解釈できるオブジェクトは存在しない．
     */
    virtual Interpreter* interpret(const QString &line) = 0;

    virtual const QString toString() const = 0;

    inline const QString &name() const
    {
        return _name;
    }

    inline void setName(const QString &n)
    {
        _name = n;
    }

private:
    QString _name;
};

}
}
}

#endif // SEQUENCE_INTERPRETER_H
