#include "EchoesSimple.h"

#include "SequenceModel.h"
#include "TrackItem.h"
#include "helper/WaveAnalysisTask.h"
#include "ControlItem.h"

#include "Alignment.h"
#include "Analyzer.h"
#include "Data.h"
#include "Dictionary.h"
#include "Echoes.h"
#include "EventItem.h"

#include "Utility.h"
#include "../../configure.h"

#include <QTest>

EchoesSimple::EchoesSimple(QObject *parent) :
    QObject(parent)
{
}

void EchoesSimple::simpleTest()
{
    using namespace stand::model;
    using namespace stand::echoes;
    const double framePeriod = 20.0;

    // set up test sequence.
    SequenceModel sequence(this);
    ControlItem *f0, *volume;
    f0 = sequence.track(0)->controlAt(0);
    volume = sequence.track(0)->controlAt(1);

    // set up notes
    TreeItem *events = sequence.track(0)->events();
    EventItem *item = new EventItem("test", sequence.track(0)->events());
    item->setData(EventItem::TickData, 0, Qt::EditRole);
    item->setData(EventItem::LengthData, 480, Qt::EditRole);
    item->setData(EventItem::NoteData, stand::A4NoteNumber, Qt::EditRole);
    events->appendChild(item);

    item = new EventItem("test2", sequence.track(0)->events());
    item->setData(EventItem::TickData, 480, Qt::EditRole);
    item->setData(EventItem::LengthData, 480, Qt::EditRole);
    item->setData(EventItem::NoteData, stand::A4NoteNumber + 1, Qt::EditRole);
    events->appendChild(item);

    // set up f0 and volume
    for(int i = 0; i < 960; i += 32)
    {
        f0->setData(i, stand::utility::NoteFrequency(stand::A4NoteNumber + (i / 480)) * (1 + (i / 32) % 2), Qt::EditRole);
        volume->setData(i, 1 + (i / 32) % 2, Qt::EditRole);
    }

    stand::echoes::Dictionary dict;
    stand::echoes::Analyzer analyzer;

    QVERIFY(dict.analyze(&analyzer, &sequence, 0, 0, 1));
    QCOMPARE(dict.size(), sequence.track(0)->events()->childCount());

    for(int i = 0; i < dict.size(); i++)
    {
        const stand::echoes::Data &d = dict.at(i).second;
        qDebug(" index = %d", i);
        for(int j = 0; j < d.length(); j++)
        {
            qDebug("  (%8d,%8f)", d.ticks()[j], d.f0()[j]);
        }
    }
}
