﻿#include "PianoView.h"

#include "Utility.h"
#include "ViewSettings.h"

#include <QPaintEvent>
#include <QPainter>

using namespace stand::view;
using namespace stand::utility;

PianoView::PianoView(QWidget *parent) :
    QWidget(parent)
{
    _settings = NULL;
    _settingsIsDeletable = false;
    setSettings(_settings);
}

PianoView::~PianoView()
{
    if(_settingsIsDeletable)
    {
        delete _settings;
    }
}


void PianoView::releaseSettings()
{
    disconnect(this, SLOT(releaseSettings()));
    _settings = NULL;
    _settings = new ViewSettings(1, 16, 64, this);
    _settingsIsDeletable = true;
    reset();
}

void PianoView::setSettings(ViewSettings *s)
{
    if(_settings)
    {
        if(_settingsIsDeletable)
        {
            delete _settings;
        }
    }

    _settingsIsDeletable = false;
    _settings = s;
    if(!s)
    {
        _settings = new ViewSettings(1, 16, 64, this);
        _settingsIsDeletable = true;
    }
    else
    {
        connect(s, SIGNAL(AboutToDelete()), this, SLOT(releaseSettings()));
    }
    connect(_settings, SIGNAL(StateChanged()), this, SLOT(reset()));
    reset();
}

void PianoView::reset()
{
    setFixedHeight(_settings->noteHeight() * 128);
}

void PianoView::paintEvent(QPaintEvent *e)
{
    QPainter p(this);
    int beginNote = e->rect().y() / _settings->noteHeight();
    int endNote = e->rect().bottom() / _settings->noteHeight() + 1;

    for(int i = beginNote; i < endNote; i++)
    {
        QColor c(255, 255, 255);
        int y = i * _settings->noteHeight();
        p.fillRect(e->rect().x(), y, e->rect().width(), _settings->noteHeight(), c);
        p.setPen(Qt::darkGray);
        if(IsBlackKey(127 - i))
        {
            c = QColor(Qt::darkGray);
            p.fillRect(0, y, width() / 2, _settings->noteHeight(), c);
        }
        p.drawLine(e->rect().x(), y, e->rect().x() + e->rect().width(), y);
    }
}
