﻿#include "TrackNameView.h"

#include <QPainter>
#include <QPaintEvent>

using namespace stand::view;

TrackNameView::TrackNameView(QWidget *parent) :
    QWidget(parent)
{
}

void TrackNameView::paintEvent(QPaintEvent *e)
{
    QPainter p(this);
    QFont font(p.font());
    font.setPointSize(height() - 6);
    font.setBold(true);
    p.setFont(font);
    p.fillRect(e->rect(), QColor(96, 96, 96));
    p.setPen(QColor(0, 192, 192));
    p.drawRect(0, 0, width() - 1, height() - 1);
    p.setPen(QColor(0, 255, 255));
    p.drawText(2, 0, width() - 8, height(), Qt::AlignRight | Qt::AlignVCenter, tr("Track"));
}
