﻿#ifndef VIEWAREA_H
#define VIEWAREA_H

#include <QFrame>

namespace stand
{
namespace view
{

class ViewArea : public QFrame
{
    Q_OBJECT
public:
    enum ResizePolicy
    {
        NoResize = 0,
        Resize
    };

    explicit ViewArea(QWidget *parent = 0);
    virtual ~ViewArea();

    void clearWidgets();
    void addWidget(QWidget *w);

    void setResizePolicy(ResizePolicy h, ResizePolicy v);

protected:
    void resizeEvent(QResizeEvent *e);
    bool eventFilter(QObject *o, QEvent *e);
signals:

public slots:
    void horizontalScroll(int x);
    void verticalScroll(int y);

protected:

    int _x, _y;
    QList<QWidget *> _widgets;
    QWidget *_frame;
    bool _frameIsCreated;
    int _lineWidth;

    ResizePolicy _h, _v;
};

}
}

#endif // VIEWAREA_H
