#ifndef VIEW_MEASUREDATA_H
#define VIEW_MEASUREDATA_H

#include <QObject>

class QUndoStack;

namespace stand
{
namespace model
{
class ControlItem;
class TreeItem;
class MeasureItem;
class SequenceModel;
class TrackItem;
}
namespace view
{

class ViewSettings : public QObject
{
    Q_OBJECT
public:
    ViewSettings(int preMeasure = 1, int noteHeight = 16, int beatWidth = 128, QObject *parent = 0);
    ~ViewSettings();

    inline int preMeasure() const
    {
        return _preMeasure;
    }

    inline int noteHeight() const
    {
        return _noteHeight;
    }

    inline int beatWidth() const
    {
        return _beatWidth;
    }

    inline bool isSnap() const
    {
        return _isSnap;
    }

    inline void setIsSnap(bool f)
    {
        _isSnap = f;
    }

    inline int snapDiv() const
    {
        return _snapDiv;
    }

    inline int snapWidth() const
    {
        return _beatWidth / _snapDiv;
    }

    inline void setSnapDiv(int s)
    {
        if(s < 0)
        {
            return;
        }
        _snapDiv = s;
    }

    inline int currentBarTick() const
    {
        return _currentBarTick;
    }

    inline void setCurrentBarTick(int tick)
    {
        int old = currentBarX();
        _currentBarTick = tick;
        emit BarMoved(old, currentBarX());
    }

    inline int currentBarX() const
    {
        return xAt(_currentBarTick);
    }

    inline int controlResolution() const
    {
        return _controlResolution;
    }

    inline void setControlResolution(int res)
    {
        _controlResolution = res;
    }

    inline void setTempo(stand::model::ControlItem *tempo)
    {
        _tempo = tempo;
        emit StateChanged();
    }

    inline void setMeasure(stand::model::MeasureItem *measure)
    {
        _measure = measure;
        emit StateChanged();
    }

    inline stand::model::ControlItem *tempo()
    {
        return _tempo;
    }

    inline stand::model::MeasureItem *measure()
    {
        return _measure;
    }

    inline int width() const
    {
        return _width;
    }

    inline void setWidth(int w)
    {
        if(_width == w)
        {
            return;
        }
        _width = w;
        emit(widthChanged(w));
    }

    inline QUndoStack *undoStack()
    {
        return _undoStack;
    }

    inline void setUndoStack(QUndoStack *undoStack)
    {
        _undoStack = undoStack;
    }

    int tickByMeasure(int measureCount) const;
    int measureAt(int tick) const;

    void setModel(stand::model::SequenceModel *model);

    void toggleReset()
    {
        emit (StateChanged());
    }

    void setTrackId(int id);
    inline int trackId() const
    {
        return _trackId;
    }

    void setControlId(int id);
    inline int controlId() const
    {
        return _controlId;
    }
    inline int controlIdPrevious() const
    {
        return _controlIdPrevious;
    }
    inline int controlSize() const
    {
        return _controlSize;
    }

    inline const QList<stand::model::TreeItem *> &controls() const
    {
        return _controls;
    }

    inline const QList<stand::model::TrackItem *> &tracks() const
    {
        return _tracks;
    }

    bool isBar(int tick) const;
    unsigned char noteAt(int y) const;
    double frequencyAt(int y) const;
    double msAt(int tick) const;
    int tickFromMs(double ms) const;
    int yAt(int note) const;
    int yAt(double frequency) const;
    int xAt(int tick) const;
    int numeratorAt(int tick) const;
    int denominatorAt(int tick) const;
    int tickAt(int x) const;


public slots:
    void setPreMeasure(int p);
    void setNoteHeight(int n);
    void setBeatWidth(int b);
    void widgetResized(int w, int h);

signals:
    void StateChanged();
    void AboutToDelete();
    void BarMoved(int oldX, int newX);
    void widthChanged(int);
    void controlTrackChanged();
    void trackChanged();
    void resetAll();

private:
    int _preMeasure;
    int _noteHeight;
    int _beatWidth;

    bool _isSnap;
    int _snapDiv;
    int _width;

    int _controlResolution;
    int _controlSize;

    int _currentBarTick;
    stand::model::ControlItem *_tempo;
    stand::model::MeasureItem *_measure;
    QUndoStack *_undoStack;

    QList<stand::model::TrackItem *> _tracks;
    int _trackId;

    QList<stand::model::TreeItem *> _controls;
    int _controlId;
    int _controlIdPrevious;
};

}
}

#endif // VIEW_MEASUREDATA_H
