#include "PitchPainter.h"

#include <QPainter>
#include <QPaintEvent>
#include "ControlItem.h"
#include "ViewSettings.h"

using namespace stand::view::helper;
using namespace stand::view;

namespace stand
{
namespace view
{
namespace helper
{
static const QColor colors[7] = {Qt::red, Qt::blue, QColor(0, 255, 0), Qt::magenta, Qt::cyan, Qt::yellow, Qt::black};
}
}
}

void PitchPainter::paint(const QList<stand::model::ControlItem *> &pitches, ViewSettings *settings, QPainter *p, QPaintEvent *e)
{
    for(int i = 0; i < pitches.size(); i++)
    {
        paint(pitches[i], settings, colors[i%7], p, e);
    }
}

void PitchPainter::paint(stand::model::ControlItem *pitch, ViewSettings *settings, const QColor &color, QPainter *p, QPaintEvent *e)
{
    if(!pitch || !settings || !p || !e)
    {
        qDebug("PitchPainter::paint(%d, %d, %d, %d); // invalid args.", pitch, settings, p, e);
        return;
    }
    p->setPen(QPen(color, 2));
    double previousValue = pitch->data(settings->tickAt(e->rect().x()), Qt::EditRole).toDouble();
    int previous = settings->yAt(previousValue);
    for(int x = e->rect().x() + 1; x <= e->rect().right(); x++)
    {
        double currentValue = pitch->data(settings->tickAt(x), Qt::EditRole).toDouble();
        int current = settings->yAt(currentValue);
        if(previousValue && currentValue)
        {
            p->drawLine(x - 1, previous, x, current);
        }
        previousValue = currentValue;
        previous = current;
    }
}
