/*
 * Decompiled with CFR 0.152.
 */
package com.ecm.graphics;

import com.ecm.graphics.data.GraphData;
import com.ecm.graphics.data.GraphDataCellCoordinate;
import com.ecm.graphics.graph3dTG.Graph3dTransformGroup;
import com.ecm.graphics.render.flatFaceRender.Graph3dFlatFaceRender;
import com.ecm.graphics.render.flatFaceRender.Graph3dSmoothRender;
import com.ecm.graphics.render.flatFaceRender.Plane2d;
import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.picking.PickCanvas;
import com.sun.j3d.utils.picking.PickResult;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Vector;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JPanel;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;

public class Graph3dJPanel
extends JPanel
implements KeyListener,
MouseListener {
    private SimpleUniverse univ = null;
    private BranchGroup scene = null;
    private PickCanvas pickCanvas = null;
    private Canvas3D canvas3d = null;
    private boolean shiftModified = false;
    private boolean altModified = false;
    private boolean ctrlModified = false;
    private Graph3dTransformGroup graph3dTransform = new Graph3dTransformGroup();
    private int xDiag1 = -1;
    private int zDiag1 = -1;
    private int xDiag2 = -1;
    private int zDiag2 = -1;
    private int oldXDiag2 = -1;
    private int oldZDiag2 = -1;
    private String newValue = "";
    private Vector values;
    private Vector oldValues;
    private double[] xLabels;
    private double[] zLabels;
    private String xLabel;
    private String yLabel;
    private String zLabel;
    private BoundingSphere bounds;
    private int frameWidth = 800;
    private int frameHeight = 600;
    private double maxX;
    private double maxY;
    private int renderKeyCode = 112;
    private int clickCount = 0;

    public void Init(Vector values, double minY, double maxY, double[] xLabels, double[] zLabels, String xLabel, String yLabel, String zLabel) {
        if (this.values != null) {
            this.oldValues = this.values;
        } else {
            GraphData.InitGraphData(values, minY, maxY);
            this.oldValues = values;
        }
        this.values = values;
        this.xLabels = xLabels;
        this.zLabels = zLabels;
        this.xLabel = xLabel;
        this.yLabel = yLabel;
        this.zLabel = zLabel;
        this.maxX = minY;
        this.maxY = maxY;
        if (!this.values.equals(this.oldValues)) {
            GraphData.InitGraphData(values, minY, maxY);
        }
        int xWidth = GraphData.getXWidth();
        int zDepth = GraphData.getZDepth();
        float percentScale = (float)((double)((xWidth + zDepth) / 2) / GraphData.getHeight()) / 4.0f;
        float fudgedScaleYMax = (float)GraphData.getMaxY() * percentScale;
        TransformGroup renderTG = null;
        if (this.renderKeyCode == 112) {
            renderTG = new Graph3dFlatFaceRender(fudgedScaleYMax);
        }
        if (this.renderKeyCode == 113) {
            renderTG = new Graph3dSmoothRender(fudgedScaleYMax);
        }
        this.graph3dTransform.Init(this.maxX, this.maxY, this.xLabels, this.zLabels, this.xLabel, this.yLabel, this.zLabel, renderTG);
    }

    public Graph3dJPanel() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(this.frameWidth, this.frameHeight));
        this.initComponents();
    }

    public void initComponents() {
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        this.canvas3d = new Canvas3D(config);
        this.canvas3d.addMouseListener((MouseListener)this);
        this.canvas3d.addKeyListener((KeyListener)this);
        this.add((Component)this.canvas3d, "Center");
        this.univ = new SimpleUniverse(this.canvas3d);
        ViewingPlatform viewingPlatform = this.univ.getViewingPlatform();
        OrbitBehavior orbit = new OrbitBehavior(this.canvas3d, 112);
        this.bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        orbit.setSchedulingBounds((Bounds)this.bounds);
        viewingPlatform.setViewPlatformBehavior((ViewPlatformBehavior)orbit);
        this.univ.getViewingPlatform().setNominalViewingTransform();
        this.univ.getViewer().getView().setMinimumFrameCycleTime(5L);
        this.univ.getViewer().getView().setSceneAntialiasingEnable(false);
        this.scene = this.createSceneGraph();
        this.pickCanvas = new PickCanvas(this.canvas3d, this.scene);
        this.pickCanvas.setMode(512);
        this.univ.addBranchGraph(this.scene);
    }

    public BranchGroup createSceneGraph() {
        BranchGroup contentBranchGroup = this.getGraphBG(this.graph3dTransform);
        contentBranchGroup.setCapability(17);
        contentBranchGroup.setCapability(13);
        contentBranchGroup.setCapability(12);
        contentBranchGroup.setCapability(14);
        return contentBranchGroup;
    }

    private BranchGroup getGraphBG(Graph3dTransformGroup graph3dTransform) {
        Transform3D myTransform3D = new Transform3D();
        myTransform3D.rotX(0.7853981633974483);
        TransformGroup graphTransformGroup = new TransformGroup(myTransform3D);
        graphTransformGroup.addChild((Node)graph3dTransform);
        Color3f bgColor = new Color3f(1.0f, 1.0f, 1.0f);
        String separator = System.getProperty("file.separator");
        String imageLocation = "graphics" + separator + "3d_Background.jpg";
        boolean exists = new File(imageLocation).exists();
        Background bgNode = null;
        if (exists) {
            TextureLoader backgroundTexture = new TextureLoader(imageLocation, null);
            bgNode = new Background(backgroundTexture.getImage());
            bgNode.setImageScaleMode(3);
        } else {
            bgNode = new Background(bgColor);
        }
        bgNode.setApplicationBounds((Bounds)this.bounds);
        BranchGroup graphBG = new BranchGroup();
        graphBG.addChild((Node)graphTransformGroup);
        graphBG.addChild((Node)bgNode);
        graphBG.setCapability(17);
        graphBG.setCapability(13);
        graphBG.setCapability(12);
        BranchGroup contentBranchGroup = new BranchGroup();
        contentBranchGroup.addChild((Node)graphBG);
        return contentBranchGroup;
    }

    public void keyTyped(KeyEvent evt) {
    }

    public void keyPressed(KeyEvent evt) {
        int key = evt.getKeyCode();
        int modified = evt.getModifiers();
        if (key == 76) {
            System.err.println(" README\n\nThis is the initial test release of the graph 3d editing project.\nNo warranty,  no help if I don't care to. Not yet that is.... \nThis test graph util may only be used within the realms of the Engiuity program.\nThis program (and all included files) may not be modified or used for commercial purposes.\nThis program may not be distributed by any other means besides that of the Enginuity main website.\nI can be contacted @ eric.c.morgan@gmail.com concerning this sofware.");
            System.out.println(" README\n\nThis is the initial test release of the graph 3d editing project.\nNo warranty, no source, no help if I don't care to. Not yet that is.... \nThis test graph util may only be used within the realms of the Engiuity program.\nThis program (and all included files) may not be modified or used for commercial purposes.\nThis program may not be distributed by any other means besides that of the Enginuity main website.\nI can be contacted @ eric.c.morgan@gmail.com concerning this sofware.");
        }
        if (modified == 1) {
            this.shiftModified = true;
            this.processShiftModification(key);
        }
        if (modified == 8) {
            this.altModified = true;
        }
        if (modified == 2) {
            this.ctrlModified = true;
            if (key < 58 && key > 47 || key == 46 || key == 45) {
                char value = evt.getKeyChar();
                this.newValue = String.valueOf(this.newValue) + value;
            }
            if (key == 82) {
                if (this.newValue != "") {
                    double newDoubleValue = Double.parseDouble(this.newValue);
                    GraphData.changeCellValue((float)newDoubleValue, GraphData.REPLACE);
                }
                this.newValue = "";
            }
            if (key == 73) {
                if (this.newValue != "") {
                    double newDoubleValue = Double.parseDouble(this.newValue);
                    GraphData.changeCellValue((float)newDoubleValue, GraphData.INCRIMENT);
                }
                this.newValue = "";
            }
            if (key == 65) {
                GraphData.selectAllCells();
            }
            if (key == 86) {
                GraphData.pasteAtCoord();
            }
            if (key == 67) {
                GraphData.copySelectedToScratchPad();
            }
        }
        if (key == 85) {
            GraphData.undoValueChange();
        }
        if (key == 44) {
            GraphData.smoothXData();
        }
        if (key == 46) {
            GraphData.smoothZData();
        }
        if (key == 47) {
            GraphData.totalSmooth();
        }
        if (key == 112 && this.renderKeyCode != 112) {
            this.renderKeyCode = 112;
            this.Init(this.values, this.maxX, this.maxY, this.xLabels, this.zLabels, this.xLabel, this.yLabel, this.zLabel);
        }
        if (key == 113 && this.renderKeyCode != 113) {
            this.renderKeyCode = 113;
            this.Init(this.values, this.maxX, this.maxY, this.xLabels, this.zLabels, this.xLabel, this.yLabel, this.zLabel);
        }
    }

    private void processShiftModification(int key) {
        int xModify = 0;
        int zModify = 0;
        if (key == 37) {
            --xModify;
        } else if (key == 39) {
            ++xModify;
        } else if (key == 38) {
            ++zModify;
        } else if (key == 40) {
            --zModify;
        }
        if (GraphData.getSelectedCount() > 0 && (xModify != 0 || zModify != 0)) {
            int xNew = GraphData.getDiagSelectTwo().getX() + xModify;
            int zNew = GraphData.getDiagSelectTwo().getZ() + zModify;
            if (xNew < GraphData.getXWidth() && zNew < GraphData.getZDepth() && xNew >= 0 && zNew >= 0) {
                GraphDataCellCoordinate newCoord = new GraphDataCellCoordinate(xNew, zNew);
                GraphData.setDiagSelectTwo(newCoord);
                GraphData.drawRectDiagonalSelection();
            }
        }
    }

    public void keyReleased(KeyEvent evt) {
        int keycode = evt.getKeyCode();
        if (keycode == 16) {
            this.shiftModified = false;
            this.xDiag1 = -1;
            this.zDiag1 = -1;
            this.xDiag2 = -1;
            this.zDiag2 = -1;
            GraphData.setDiagSelectOne(null);
            GraphData.setDiagSelectTwo(null);
        }
        if (keycode == 17) {
            this.ctrlModified = false;
            this.newValue = "";
        }
        if (keycode == 18) {
            this.altModified = false;
        }
    }

    public void mousePressed(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void mouseClicked(MouseEvent e) {
        this.clickCount = e.getClickCount();
        if (e.getClickCount() == 1) {
            Plane2d thePlane;
            Shape3D s;
            this.xDiag1 = -1;
            this.zDiag1 = -1;
            this.xDiag2 = -1;
            this.zDiag2 = -1;
            this.oldXDiag2 = -1;
            this.oldZDiag2 = -1;
            this.pickCanvas.setShapeLocation(e);
            PickResult result = this.pickCanvas.pickClosest();
            if (result != null && (s = (Shape3D)result.getNode(1)) != null && s.getClass().getName().contains("Plane2d") && (thePlane = (Plane2d)s).isValuePlane()) {
                if (!this.shiftModified) {
                    GraphData.deSelectAllCells();
                }
                GraphDataCellCoordinate tempCoord = new GraphDataCellCoordinate(thePlane.getXCoord(), thePlane.getZCoord());
                GraphData.flipSelectedValue(tempCoord);
                if (GraphData.getDiagSelectOne() == null) {
                    GraphData.setDiagSelectOne(GraphData.getLastSelectedCoord());
                }
            }
        }
        if (e.getClickCount() > 1 && this.shiftModified && GraphData.getDiagSelectOne() != null) {
            GraphData.setDiagSelectTwo(GraphData.getLastSelectedCoord());
            GraphData.drawRectDiagonalSelection();
        }
    }

    public void shutdownCleanup() {
    }
}

