/*
 * Decompiled with CFR 0.152.
 */
package com.ecm.graphics.exampleCode;

import Jama.Matrix;

public class FitTest {
    static double[] x_values = new double[]{-3.0, -2.0, -1.5, 0.0, 1.0, 2.3, 3.0, 4.0, 5.5};
    static double[] y_values = new double[]{-15.0, -10.0, -7.0, -5.0, -4.0, -5.0, -7.0, -10.0, -15.0};
    static double a;
    static double b;
    static int n;
    static int m;
    static double[][] A_array;
    static double[][] B_array;

    static {
        n = 6;
        m = 0;
    }

    public static void main(String[] args) {
        FitTest.fit();
    }

    public static void fit() {
        a = FitTest.getMinValue(x_values);
        System.out.println("Min Value is:" + a);
        b = FitTest.getMaxValue(x_values);
        System.out.println("Max Value is:" + b);
        m = x_values.length - 1;
        n = m / 4;
        if (n == 0) {
            n = 1;
        }
        System.out.println("N: " + n);
        A_array = new double[n + 1][n + 1];
        B_array = new double[n + 1][1];
        System.out.println("\nAlpha Array values\n-----------------");
        int i = 0;
        while (i <= n) {
            int j = 0;
            while (j <= n) {
                double kValue = FitTest.evalChebyshev(FitTest.getZSubK(0), i) * FitTest.evalChebyshev(FitTest.getZSubK(0), j);
                int k = 1;
                while (k <= m) {
                    kValue += FitTest.evalChebyshev(FitTest.getZSubK(k), i) * FitTest.evalChebyshev(FitTest.getZSubK(k), j);
                    ++k;
                }
                FitTest.A_array[j][i] = kValue;
                System.out.print(String.valueOf(kValue) + "; ");
                ++j;
            }
            System.out.print("\n");
            ++i;
        }
        System.out.println("------------------");
        i = 0;
        while (i <= n) {
            double kValue = y_values[0] * FitTest.evalChebyshev(FitTest.getZSubK(0), i);
            int k = 1;
            while (k <= m) {
                kValue += y_values[k] * FitTest.evalChebyshev(FitTest.getZSubK(k), i);
                ++k;
            }
            FitTest.B_array[i][0] = kValue;
            System.out.println("Beta Array Value: " + kValue);
            ++i;
        }
        System.out.println("------------------");
        Matrix alpha_matrix = new Matrix(A_array);
        Matrix beta_matrix = new Matrix(B_array);
        Matrix resultMatrix = alpha_matrix.solve(beta_matrix);
        double[] results = resultMatrix.getColumnPackedCopy();
        int i2 = 0;
        while (i2 < results.length) {
            System.out.println("Coefficients:" + results[i2]);
            ++i2;
        }
        System.out.println("------------------");
        System.out.println("Y Values");
        i2 = 0;
        while (i2 < x_values.length) {
            double tempValue;
            double interimValue = FitTest.getScaledXValue(x_values[i2]);
            double yValue = tempValue = FitTest.evalChebyshev(interimValue, 0) * results[0];
            int j = 1;
            while (j <= n) {
                tempValue = FitTest.evalChebyshev(interimValue, j) * results[j];
                yValue += tempValue;
                ++j;
            }
            System.out.print(String.valueOf(yValue) + "; ");
            ++i2;
        }
    }

    private static double getScaledXValue(double value) {
        double returnValue = (2.0 * value - a - b) / (b - a);
        return returnValue;
    }

    private static double evalChebyshev(double value, int index) {
        double returnValue = Math.cos((double)index * Math.acos(value));
        return returnValue;
    }

    private static double getZSubK(int index) {
        double returnValue = (2.0 * x_values[index] - a - b) / (b - a);
        return returnValue;
    }

    private static double getMaxValue(double[] valueArray) {
        double returnValue = valueArray[0];
        int i = 1;
        while (i < valueArray.length) {
            double temp = valueArray[i];
            if (temp > returnValue) {
                returnValue = temp;
            }
            ++i;
        }
        return returnValue;
    }

    private static double getMinValue(double[] valueArray) {
        double returnValue = valueArray[0];
        int i = 1;
        while (i < valueArray.length) {
            double temp = valueArray[i];
            if (temp < returnValue) {
                returnValue = temp;
            }
            ++i;
        }
        return returnValue;
    }
}

