/*
 * Decompiled with CFR 0.152.
 */
package com.ecm.graphics.exampleCode;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.util.Random;
import javax.media.j3d.Alpha;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Geometry;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.Node;
import javax.media.j3d.PointArray;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TriangleArray;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;

public final class Stars
extends Applet {
    private SimpleUniverse u = null;

    public Stars() {
        this.setLayout(new BorderLayout());
        Canvas3D canvas = this.createCanvas();
        this.add("Center", (Component)canvas);
        this.u = new SimpleUniverse(canvas);
        BranchGroup scene = this.createContent();
        this.u.getViewingPlatform().setNominalViewingTransform();
        OrbitBehavior orbit = new OrbitBehavior(canvas);
        orbit.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.POSITIVE_INFINITY));
        this.u.getViewingPlatform().setViewPlatformBehavior((ViewPlatformBehavior)orbit);
        scene.compile();
        this.u.addBranchGraph(scene);
    }

    private Canvas3D createCanvas() {
        GraphicsConfigTemplate3D graphicsTemplate = new GraphicsConfigTemplate3D();
        GraphicsConfiguration gc1 = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)graphicsTemplate);
        return new Canvas3D(gc1);
    }

    private BranchGroup createContent() {
        BranchGroup objRoot = new BranchGroup();
        Shape3D shape = new Shape3D();
        TriangleArray tri = new TriangleArray(3, 5);
        tri.setCoordinate(0, new Point3f(0.5f, 0.0f, 0.0f));
        tri.setCoordinate(1, new Point3f(0.0f, 0.5f, 0.0f));
        tri.setCoordinate(2, new Point3f(-0.5f, 0.0f, 0.0f));
        tri.setColor(0, new Color3f(1.0f, 0.0f, 0.0f));
        tri.setColor(1, new Color3f(0.0f, 1.0f, 0.0f));
        tri.setColor(2, new Color3f(0.0f, 0.0f, 1.0f));
        Appearance ap = new Appearance();
        PolygonAttributes pa = new PolygonAttributes();
        pa.setCullFace(0);
        ap.setPolygonAttributes(pa);
        shape.setAppearance(ap);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 5.0);
        TransformGroup tg = new TransformGroup();
        Transform3D yAxis = new Transform3D();
        Alpha rotationAlpha = new Alpha(-1, 4000L);
        tg.setCapability(18);
        RotationInterpolator rotator = new RotationInterpolator(rotationAlpha, tg, yAxis, 0.0f, (float)Math.PI * 2);
        rotator.setSchedulingBounds((Bounds)bounds);
        shape.setGeometry((Geometry)tri);
        tg.addChild((Node)rotator);
        tg.addChild((Node)shape);
        objRoot.addChild((Node)tg);
        objRoot.addChild((Node)this.createBackGraph());
        return objRoot;
    }

    private Background createBackGraph() {
        Background background = new Background();
        BoundingSphere infiniteBounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), Double.MAX_VALUE);
        background.setApplicationBounds((Bounds)infiniteBounds);
        BranchGroup bg = new BranchGroup();
        Random rand = new Random();
        PointArray starfield = new PointArray(20000, 5);
        float[] point = new float[3];
        float[] brightness = new float[3];
        int i = 0;
        while (i < 20000) {
            float mag;
            point[0] = rand.nextInt(2) == 0 ? rand.nextFloat() * -1.0f : rand.nextFloat();
            point[1] = rand.nextInt(2) == 0 ? rand.nextFloat() * -1.0f : rand.nextFloat();
            point[2] = rand.nextInt(2) == 0 ? rand.nextFloat() * -1.0f : rand.nextFloat();
            starfield.setCoordinate(i, point);
            brightness[0] = mag = rand.nextFloat();
            brightness[1] = mag;
            brightness[2] = mag;
            starfield.setColor(i, brightness);
            ++i;
        }
        bg.addChild((Node)new Shape3D((Geometry)starfield));
        background.setGeometry(bg);
        return background;
    }

    public static void main(String[] args) {
        MainFrame frame = new MainFrame((Applet)new Stars(), 320, 280);
        frame.setTitle("My god...it's full of stars!");
    }
}

