/*
 * Decompiled with CFR 0.152.
 */
package com.ecm.graphics.render.flatFaceRender;

import com.ecm.graphics.data.GraphData;
import com.ecm.graphics.render.flatFaceRender.DataChanger;
import com.ecm.graphics.render.flatFaceRender.Plane2d;
import com.ecm.graphics.tools.ColorTable;
import com.ecm.graphics.tools.FitData;
import javax.media.j3d.Node;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3f;

public class Graph3dInterpolatedRender
extends TransformGroup
implements DataChanger {
    private int xWidth = GraphData.getXWidth();
    private int zDepth = GraphData.getZDepth();
    private float fudgedScaleYMax;
    private int totalFineWidth;
    private double[][] fineValues;
    private double resolution = 0.25;

    public Graph3dInterpolatedRender(float fudgedScaleYMax) {
        int j;
        this.fudgedScaleYMax = fudgedScaleYMax;
        System.out.println("hit 1");
        this.setCapability(18);
        this.setCapability(12);
        this.setCapability(13);
        this.setCapability(14);
        this.setCapability(17);
        double[][] allValues = new double[this.xWidth][this.zDepth];
        int i = 0;
        while (i < this.xWidth - 1) {
            int j2 = 0;
            while (j2 < this.zDepth - 1) {
                allValues[i][j2] = GraphData.getCellValue(i, j2);
                ++j2;
            }
            ++i;
        }
        System.out.println("hit 2");
        this.totalFineWidth = this.xWidth * 4;
        double[] xVals = new double[this.xWidth];
        double[] yVals = new double[this.xWidth];
        double[] xValsFine = new double[this.totalFineWidth];
        double[] yValsFine = new double[this.totalFineWidth];
        this.fineValues = new double[this.totalFineWidth][this.zDepth];
        int i2 = 0;
        while (i2 < this.zDepth - 1) {
            j = 0;
            while (j < this.xWidth - 1) {
                xVals[j] = j;
                yVals[j] = allValues[j][i2];
                System.out.println("Values:" + i2 + "   >" + allValues[j][i2]);
                ++j;
            }
            FitData.init(xVals, yVals);
            int k = 0;
            while (k < this.xWidth - 1) {
                double xCount = 0.0;
                while (xCount < 1.0) {
                    double Xnew = (double)k + xCount;
                    double smoothed = FitData.getSmoothYValue(Xnew);
                    System.out.println(String.valueOf(Xnew) + ": >" + smoothed);
                    this.fineValues[k][i2] = smoothed;
                    xCount += this.resolution;
                }
                System.out.println("-------------------------");
                ++k;
            }
            ++i2;
        }
        System.out.println("hit 3 ");
        i2 = 0;
        while (i2 < this.zDepth - 1) {
            j = 0;
            while ((double)j < (double)this.totalFineWidth - 1.0 / this.resolution) {
                this.addChild((Node)this.getValueFace(j, i2));
                ++j;
            }
            ++i2;
        }
        System.out.println("hit 4");
    }

    private Plane2d getValueFace(int x, int z) {
        float theValue1 = (float)this.fineValues[x][z];
        float theValue2 = (float)this.fineValues[x + 1][z];
        float theValue3 = (float)this.fineValues[x + 1][z + 1];
        float theValue4 = (float)this.fineValues[x][z + 1];
        System.out.println(String.valueOf(x) + " ::::::  " + z);
        float x1 = (float)x / 4.0f;
        float x2 = (float)((double)x1 + this.resolution);
        System.out.println(String.valueOf(x1) + ",,,,,,,," + x2);
        Point3f A = new Point3f(x1, this.getTransValue(theValue1), (float)(-z));
        Point3f B = new Point3f(x2, this.getTransValue(theValue2), (float)(-z));
        Point3f C = new Point3f(x2, this.getTransValue(theValue3), (float)(-z - 1));
        Point3f D = new Point3f(x1, this.getTransValue(theValue4), (float)(-z - 1));
        Plane2d plane2d = new Plane2d(A, B, C, D, ColorTable.getColor(theValue1), false, x, z, theValue1, false);
        return plane2d;
    }

    private float getTransValue(float inValue) {
        return inValue / (float)GraphData.getMaxY() * this.fudgedScaleYMax;
    }

    public void modifyHeight(int x, int z, float value, int totalCount) {
    }
}

