/*
 * Decompiled with CFR 0.152.
 */
package com.ecm.graphics.render.flatFaceRender;

import com.ecm.graphics.tools.ColorTable;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.Shape3D;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;

public class Plane2d
extends Shape3D {
    private Color3f selectedColor = ColorTable.getSelectedColor();
    private Point3f A = null;
    private Point3f B = null;
    private Point3f C = null;
    private Point3f D = null;
    private boolean isValuePlane = false;
    private Appearance app;
    private int xCoord = 0;
    private int zCoord = 0;
    private Color3f color;
    private Color3f oldColor;
    public float theValue;
    private double oldValue;
    private boolean isTwoSided = false;

    public Plane2d(Point3f A, Point3f B, Point3f C, Point3f D, Color3f color, boolean isValuePlane, int xCoord, int zCoord, float theValue, boolean isTwoSided) {
        this.isValuePlane = isValuePlane;
        this.color = color;
        this.theValue = theValue;
        this.oldValue = theValue;
        this.A = A;
        this.B = B;
        this.C = C;
        this.D = D;
        this.xCoord = xCoord;
        this.zCoord = zCoord;
        this.isTwoSided = isTwoSided;
        this.renderPlane(A, B, C, D);
    }

    private void renderPlane(Point3f A, Point3f B, Point3f C, Point3f D) {
        Point3f[] pts = null;
        int[] stripCounts = null;
        int[] contourCount = null;
        if (this.isTwoSided) {
            pts = new Point3f[]{C, D, A, B, C, B, A, D};
            stripCounts = new int[]{4, 4};
            contourCount = new int[]{1, 1};
        } else {
            pts = new Point3f[]{C, D, A, B};
            stripCounts = new int[]{4};
            contourCount = new int[]{1};
        }
        GeometryInfo gInf = new GeometryInfo(5);
        gInf.setCoordinates(pts);
        gInf.setStripCounts(stripCounts);
        gInf.setContourCounts(contourCount);
        NormalGenerator ng = new NormalGenerator();
        ng.setCreaseAngle((double)((float)Math.toRadians(30.0)));
        ng.generateNormals(gInf);
        this.setGeometry((Geometry)gInf.getGeometryArray());
        this.app = new Appearance();
        ColoringAttributes ca = new ColoringAttributes(this.color, 2);
        this.app.setColoringAttributes(ca);
        this.app.setCapability(9);
        this.setAppearance(this.app);
    }

    public void setSelected(boolean value) {
        if (value) {
            this.setEditColoring();
        } else {
            this.setValueColoring();
        }
    }

    private void setEditColoring() {
        ColoringAttributes ca = new ColoringAttributes(this.selectedColor, 2);
        this.app.setColoringAttributes(ca);
    }

    private void setValueColoring() {
        ColoringAttributes ca = new ColoringAttributes(ColorTable.getColor(this.theValue), 2);
        this.app.setColoringAttributes(ca);
    }

    public boolean isValuePlane() {
        return this.isValuePlane;
    }

    public int getXCoord() {
        return this.xCoord;
    }

    public int getZCoord() {
        return this.zCoord;
    }
}

