/*
 * Decompiled with CFR 0.152.
 */
package com.ecm.graphics.tools;

import Jama.Matrix;

public class FitData {
    static double[] x_values;
    static double[] y_values;
    static double a;
    static double b;
    static int n;
    static int m;
    static double[][] A_array;
    static double[][] B_array;
    static double[] results;

    static {
        n = 6;
        m = 0;
    }

    public static void init(double[] xVals, double[] yVals) {
        x_values = xVals;
        y_values = yVals;
        a = FitData.getMinValue(x_values);
        b = FitData.getMaxValue(x_values);
        m = x_values.length - 1;
        n = m / 4;
        if (n == 0) {
            n = 1;
        }
        A_array = new double[n + 1][n + 1];
        B_array = new double[n + 1][1];
        int i = 0;
        while (i <= n) {
            int j = 0;
            while (j <= n) {
                double kValue = FitData.evalChebyshev(FitData.getZSubK(0), i) * FitData.evalChebyshev(FitData.getZSubK(0), j);
                int k = 1;
                while (k <= m) {
                    kValue += FitData.evalChebyshev(FitData.getZSubK(k), i) * FitData.evalChebyshev(FitData.getZSubK(k), j);
                    ++k;
                }
                FitData.A_array[j][i] = kValue;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i <= n) {
            double kValue = y_values[0] * FitData.evalChebyshev(FitData.getZSubK(0), i);
            int k = 1;
            while (k <= m) {
                kValue += y_values[k] * FitData.evalChebyshev(FitData.getZSubK(k), i);
                ++k;
            }
            FitData.B_array[i][0] = kValue;
            ++i;
        }
        Matrix alpha_matrix = new Matrix(A_array);
        Matrix beta_matrix = new Matrix(B_array);
        Matrix resultMatrix = alpha_matrix.solve(beta_matrix);
        results = resultMatrix.getColumnPackedCopy();
    }

    public static double getSmoothYValue(double xValue) {
        double interimValue = FitData.getScaledXValue(xValue);
        double yValue = FitData.evalChebyshev(interimValue, 0) * results[0];
        int j = 1;
        while (j <= n) {
            yValue += FitData.evalChebyshev(interimValue, j) * results[j];
            ++j;
        }
        return yValue;
    }

    private static double getScaledXValue(double value) {
        double returnValue = (2.0 * value - a - b) / (b - a);
        return returnValue;
    }

    private static double evalChebyshev(double value, int index) {
        double returnValue = Math.cos((double)index * Math.acos(value));
        return returnValue;
    }

    private static double getZSubK(int index) {
        double returnValue = (2.0 * x_values[index] - a - b) / (b - a);
        return returnValue;
    }

    private static double getMaxValue(double[] valueArray) {
        double returnValue = valueArray[0];
        int i = 1;
        while (i < valueArray.length) {
            double temp = valueArray[i];
            if (temp > returnValue) {
                returnValue = temp;
            }
            ++i;
        }
        return returnValue;
    }

    private static double getMinValue(double[] valueArray) {
        double returnValue = valueArray[0];
        int i = 1;
        while (i < valueArray.length) {
            double temp = valueArray[i];
            if (temp < returnValue) {
                returnValue = temp;
            }
            ++i;
        }
        return returnValue;
    }
}

