/*
 * Decompiled with CFR 0.152.
 */
package ZoeloeSoft.projects.JFontChooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JFontChooser
extends JDialog {
    public static int OK_OPTION = 0;
    public static int CANCEL_OPTION = 1;
    private JList fontList;
    private JList sizeList;
    private JCheckBox cbBold;
    private JCheckBox cbItalic;
    private JTextArea txtSample;
    private int OPTION;
    private String[] sizes = new String[]{"2", "4", "6", "8", "10", "12", "14", "16", "18", "20", "22", "24", "30", "36", "48", "72"};

    public int showDialog(Font font) {
        this.setFont(font);
        return this.showDialog();
    }

    public int showDialog() {
        this.setVisible(true);
        return this.OPTION;
    }

    public JFontChooser(Frame frame) {
        super(frame, true);
        this.setTitle("JFontChooser");
        this.OPTION = CANCEL_OPTION;
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFontChooser.this.OPTION = OK_OPTION;
                JFontChooser.this.setVisible(false);
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFontChooser.this.OPTION = CANCEL_OPTION;
                JFontChooser.this.setVisible(false);
            }
        });
        this.fontList = new JList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()){

            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(150, 144);
            }
        };
        this.fontList.setSelectionMode(0);
        this.sizeList = new JList(this.sizes){

            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(25, 144);
            }
        };
        this.sizeList.setSelectionMode(0);
        this.cbBold = new JCheckBox("Bold");
        this.cbItalic = new JCheckBox("Italic");
        this.txtSample = new JTextArea(){

            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(385, 80);
            }
        };
        this.txtSample.setText("The quick brown fox jumped over the fence");
        this.setFont(null);
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JFontChooser.this.txtSample.setFont(JFontChooser.this.getCurrentFont());
            }
        };
        this.fontList.addListSelectionListener(listSelectionListener);
        this.sizeList.addListSelectionListener(listSelectionListener);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFontChooser.this.txtSample.setFont(JFontChooser.this.getCurrentFont());
            }
        };
        this.cbBold.addActionListener(actionListener);
        this.cbItalic.addActionListener(actionListener);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JScrollPane(this.fontList), "Center");
        jPanel.add((Component)new JScrollPane(this.sizeList), "East");
        this.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout());
        jPanel3.add(this.cbBold);
        jPanel3.add(this.cbItalic);
        jPanel2.add((Component)jPanel3, "North");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(2, 1));
        jPanel4.add(jButton);
        jPanel4.add(jButton2);
        jPanel2.add((Component)jPanel4, "South");
        this.getContentPane().add((Component)jPanel2, "East");
        this.getContentPane().add((Component)new JScrollPane(this.txtSample), "South");
        this.setSize(200, 200);
        this.setResizable(false);
        this.pack();
    }

    public void setFont(Font font) {
        if (font == null) {
            font = this.txtSample.getFont();
        }
        this.fontList.setSelectedValue(font.getName(), true);
        this.fontList.ensureIndexIsVisible(this.fontList.getSelectedIndex());
        this.sizeList.setSelectedValue("" + font.getSize(), true);
        this.sizeList.ensureIndexIsVisible(this.sizeList.getSelectedIndex());
        this.cbBold.setSelected(font.isBold());
        this.cbItalic.setSelected(font.isItalic());
    }

    public Font getFont() {
        if (this.OPTION == OK_OPTION) {
            return this.getCurrentFont();
        }
        return null;
    }

    private Font getCurrentFont() {
        String string = (String)this.fontList.getSelectedValue();
        int n = Integer.parseInt((String)this.sizeList.getSelectedValue());
        int n2 = 0;
        if (this.cbBold.isSelected()) {
            ++n2;
        }
        if (this.cbItalic.isSelected()) {
            n2 += 2;
        }
        return new Font(string, n2, n);
    }
}

