/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.nio.Buffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Context;
import javax.media.j3d.Drawable;
import javax.media.j3d.DrawingSurfaceObject;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GraphicsConfigInfo;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.ImageComponent2DRetained;
import javax.media.j3d.ShaderAttrLoc;
import javax.media.j3d.ShaderError;
import javax.media.j3d.ShaderId;
import javax.media.j3d.ShaderProgramId;

abstract class Pipeline {
    private static Pipeline pipeline;
    private Type pipelineType = null;

    protected Pipeline() {
    }

    static void createPipeline(Type type) {
        String string = null;
        switch (type) {
            case NATIVE_OGL: 
            case NATIVE_D3D: {
                string = "javax.media.j3d.NativePipeline";
                break;
            }
            case JOGL: {
                string = "javax.media.j3d.JoglPipeline";
                break;
            }
            case NOOP: {
                string = "javax.media.j3d.NoopPipeline";
                break;
            }
            default: {
                throw new AssertionError((Object)"missing case statement");
            }
        }
        final String string2 = string;
        pipeline = (Pipeline)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class<?> clazz = Class.forName(string2);
                    return clazz.newInstance();
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        });
        pipeline.initialize(type);
    }

    static Pipeline getPipeline() {
        return pipeline;
    }

    void initialize(Type type) {
        this.setPipelineType(type);
    }

    private void setPipelineType(Type type) {
        this.pipelineType = type;
    }

    Type getPipelineType() {
        return this.pipelineType;
    }

    String getPipelineName() {
        switch (this.pipelineType) {
            case NATIVE_OGL: {
                return "NATIVE_OGL";
            }
            case NATIVE_D3D: {
                return "NATIVE_D3D";
            }
            case JOGL: {
                return "JOGL";
            }
            case NOOP: {
                return "NOOP";
            }
        }
        throw new AssertionError((Object)"missing case statement");
    }

    String getRendererName() {
        switch (this.pipelineType) {
            case NATIVE_OGL: 
            case JOGL: {
                return "OpenGL";
            }
            case NATIVE_D3D: {
                return "DirectX";
            }
            case NOOP: {
                return "None";
            }
        }
        throw new AssertionError((Object)"missing case statement");
    }

    abstract void loadLibraries(int var1);

    abstract boolean isCgLibraryAvailable();

    abstract boolean isGLSLLibraryAvailable();

    abstract void freeD3DArray(GeometryArrayRetained var1, boolean var2);

    abstract void execute(Context var1, GeometryArrayRetained var2, int var3, boolean var4, boolean var5, boolean var6, int var7, int var8, int var9, int var10, int[] var11, int var12, int[] var13, int var14, int var15, int[] var16, float[] var17, float[] var18, int var19);

    abstract void executeVA(Context var1, GeometryArrayRetained var2, int var3, boolean var4, boolean var5, int var6, int var7, int var8, int var9, float[] var10, double[] var11, int var12, float[] var13, byte[] var14, int var15, float[] var16, int var17, int[] var18, int[] var19, float[][] var20, int var21, int[] var22, int var23, int[] var24, int var25, Object[] var26, int var27);

    abstract void executeVABuffer(Context var1, GeometryArrayRetained var2, int var3, boolean var4, boolean var5, int var6, int var7, int var8, int var9, Object var10, int var11, Object var12, float[] var13, byte[] var14, int var15, Object var16, int var17, int[] var18, int[] var19, Object[] var20, int var21, int[] var22, int var23, int[] var24, int var25, Object[] var26, int var27);

    abstract void executeInterleavedBuffer(Context var1, GeometryArrayRetained var2, int var3, boolean var4, boolean var5, boolean var6, int var7, int var8, int var9, int var10, int[] var11, int var12, int[] var13, int var14, Object var15, float[] var16, int var17);

    abstract void setVertexFormat(Context var1, GeometryArrayRetained var2, int var3, boolean var4, boolean var5);

    abstract void disableGlobalAlpha(Context var1, GeometryArrayRetained var2, int var3, boolean var4, boolean var5);

    abstract void buildGA(Context var1, GeometryArrayRetained var2, int var3, boolean var4, boolean var5, float var6, boolean var7, int var8, int var9, int var10, int var11, int[] var12, int var13, int[] var14, int var15, int[] var16, double[] var17, double[] var18, float[] var19);

    abstract void buildGAForByRef(Context var1, GeometryArrayRetained var2, int var3, boolean var4, boolean var5, float var6, boolean var7, int var8, int var9, int var10, int var11, float[] var12, double[] var13, int var14, float[] var15, byte[] var16, int var17, float[] var18, int var19, int[] var20, int[] var21, float[][] var22, int var23, int[] var24, int[] var25, int var26, Object[] var27, double[] var28, double[] var29);

    abstract void executeIndexedGeometry(Context var1, GeometryArrayRetained var2, int var3, boolean var4, boolean var5, boolean var6, int var7, int var8, int var9, int var10, int var11, int[] var12, int var13, int[] var14, int var15, int[] var16, int var17, float[] var18, float[] var19, int var20, int[] var21);

    abstract void executeIndexedGeometryBuffer(Context var1, GeometryArrayRetained var2, int var3, boolean var4, boolean var5, boolean var6, int var7, int var8, int var9, int var10, int var11, int[] var12, int var13, int[] var14, int var15, Object var16, float[] var17, int var18, int[] var19);

    abstract void executeIndexedGeometryVA(Context var1, GeometryArrayRetained var2, int var3, boolean var4, boolean var5, int var6, int var7, int var8, int var9, int var10, float[] var11, double[] var12, float[] var13, byte[] var14, float[] var15, int var16, int[] var17, float[][] var18, int var19, int[] var20, int var21, int var22, Object[] var23, int var24, int[] var25);

    abstract void executeIndexedGeometryVABuffer(Context var1, GeometryArrayRetained var2, int var3, boolean var4, boolean var5, int var6, int var7, int var8, int var9, int var10, Object var11, Object var12, float[] var13, byte[] var14, Object var15, int var16, int[] var17, Object[] var18, int var19, int[] var20, int var21, int var22, Object[] var23, int var24, int[] var25);

    abstract void buildIndexedGeometry(Context var1, GeometryArrayRetained var2, int var3, boolean var4, boolean var5, float var6, boolean var7, int var8, int var9, int var10, int var11, int var12, int[] var13, int var14, int[] var15, int var16, int[] var17, double[] var18, double[] var19, float[] var20, int[] var21);

    abstract void readRaster(Context var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, Object var10, int var11, Object var12);

    abstract ShaderError setCgUniform1i(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4);

    abstract ShaderError setCgUniform1f(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, float var4);

    abstract ShaderError setCgUniform2i(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int[] var4);

    abstract ShaderError setCgUniform2f(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, float[] var4);

    abstract ShaderError setCgUniform3i(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int[] var4);

    abstract ShaderError setCgUniform3f(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, float[] var4);

    abstract ShaderError setCgUniform4i(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int[] var4);

    abstract ShaderError setCgUniform4f(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, float[] var4);

    abstract ShaderError setCgUniformMatrix3f(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, float[] var4);

    abstract ShaderError setCgUniformMatrix4f(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, float[] var4);

    abstract ShaderError setCgUniform1iArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, int[] var5);

    abstract ShaderError setCgUniform1fArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, float[] var5);

    abstract ShaderError setCgUniform2iArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, int[] var5);

    abstract ShaderError setCgUniform2fArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, float[] var5);

    abstract ShaderError setCgUniform3iArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, int[] var5);

    abstract ShaderError setCgUniform3fArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, float[] var5);

    abstract ShaderError setCgUniform4iArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, int[] var5);

    abstract ShaderError setCgUniform4fArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, float[] var5);

    abstract ShaderError setCgUniformMatrix3fArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, float[] var5);

    abstract ShaderError setCgUniformMatrix4fArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, float[] var5);

    abstract ShaderError createCgShader(Context var1, int var2, ShaderId[] var3);

    abstract ShaderError destroyCgShader(Context var1, ShaderId var2);

    abstract ShaderError compileCgShader(Context var1, ShaderId var2, String var3);

    abstract ShaderError createCgShaderProgram(Context var1, ShaderProgramId[] var2);

    abstract ShaderError destroyCgShaderProgram(Context var1, ShaderProgramId var2);

    abstract ShaderError linkCgShaderProgram(Context var1, ShaderProgramId var2, ShaderId[] var3);

    abstract void lookupCgVertexAttrNames(Context var1, ShaderProgramId var2, int var3, String[] var4, boolean[] var5);

    abstract void lookupCgShaderAttrNames(Context var1, ShaderProgramId var2, int var3, String[] var4, ShaderAttrLoc[] var5, int[] var6, int[] var7, boolean[] var8);

    abstract ShaderError useCgShaderProgram(Context var1, ShaderProgramId var2);

    abstract ShaderError setGLSLUniform1i(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4);

    abstract ShaderError setGLSLUniform1f(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, float var4);

    abstract ShaderError setGLSLUniform2i(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int[] var4);

    abstract ShaderError setGLSLUniform2f(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, float[] var4);

    abstract ShaderError setGLSLUniform3i(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int[] var4);

    abstract ShaderError setGLSLUniform3f(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, float[] var4);

    abstract ShaderError setGLSLUniform4i(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int[] var4);

    abstract ShaderError setGLSLUniform4f(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, float[] var4);

    abstract ShaderError setGLSLUniformMatrix3f(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, float[] var4);

    abstract ShaderError setGLSLUniformMatrix4f(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, float[] var4);

    abstract ShaderError setGLSLUniform1iArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, int[] var5);

    abstract ShaderError setGLSLUniform1fArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, float[] var5);

    abstract ShaderError setGLSLUniform2iArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, int[] var5);

    abstract ShaderError setGLSLUniform2fArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, float[] var5);

    abstract ShaderError setGLSLUniform3iArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, int[] var5);

    abstract ShaderError setGLSLUniform3fArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, float[] var5);

    abstract ShaderError setGLSLUniform4iArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, int[] var5);

    abstract ShaderError setGLSLUniform4fArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, float[] var5);

    abstract ShaderError setGLSLUniformMatrix3fArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, float[] var5);

    abstract ShaderError setGLSLUniformMatrix4fArray(Context var1, ShaderProgramId var2, ShaderAttrLoc var3, int var4, float[] var5);

    abstract ShaderError createGLSLShader(Context var1, int var2, ShaderId[] var3);

    abstract ShaderError destroyGLSLShader(Context var1, ShaderId var2);

    abstract ShaderError compileGLSLShader(Context var1, ShaderId var2, String var3);

    abstract ShaderError createGLSLShaderProgram(Context var1, ShaderProgramId[] var2);

    abstract ShaderError destroyGLSLShaderProgram(Context var1, ShaderProgramId var2);

    abstract ShaderError linkGLSLShaderProgram(Context var1, ShaderProgramId var2, ShaderId[] var3);

    abstract ShaderError bindGLSLVertexAttrName(Context var1, ShaderProgramId var2, String var3, int var4);

    abstract void lookupGLSLShaderAttrNames(Context var1, ShaderProgramId var2, int var3, String[] var4, ShaderAttrLoc[] var5, int[] var6, int[] var7, boolean[] var8);

    abstract ShaderError useGLSLShaderProgram(Context var1, ShaderProgramId var2);

    abstract void freeD3DSurface(ImageComponent2DRetained var1, int var2);

    boolean checkNativeBufferAccess(Buffer buffer) {
        return true;
    }

    abstract void cleanupRenderer();

    abstract void updateColoringAttributes(Context var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, boolean var9, int var10);

    abstract void updateDirectionalLight(Context var1, int var2, float var3, float var4, float var5, float var6, float var7, float var8);

    abstract void updatePointLight(Context var1, int var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11);

    abstract void updateSpotLight(Context var1, int var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12, float var13, float var14, float var15, float var16);

    abstract void updateExponentialFog(Context var1, float var2, float var3, float var4, float var5);

    abstract void updateLinearFog(Context var1, float var2, float var3, float var4, double var5, double var7);

    abstract void updateLineAttributes(Context var1, float var2, int var3, int var4, int var5, boolean var6);

    abstract void updateMaterial(Context var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12, float var13, float var14, float var15, float var16, float var17, float var18, int var19, boolean var20);

    abstract void updateModelClip(Context var1, int var2, boolean var3, double var4, double var6, double var8, double var10);

    abstract void updatePointAttributes(Context var1, float var2, boolean var3);

    abstract void updatePolygonAttributes(Context var1, int var2, int var3, boolean var4, float var5, float var6);

    abstract void updateRenderingAttributes(Context var1, boolean var2, boolean var3, boolean var4, boolean var5, int var6, float var7, int var8, boolean var9, boolean var10, int var11, boolean var12, boolean var13, int var14, int var15, int var16, int var17, int var18, int var19, int var20);

    abstract void updateTexCoordGeneration(Context var1, boolean var2, int var3, int var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12, float var13, float var14, float var15, float var16, float var17, float var18, float var19, float var20, double[] var21);

    abstract void updateTransparencyAttributes(Context var1, float var2, int var3, int var4, boolean var5, boolean var6, int var7, int var8, int var9);

    abstract void updateTextureAttributes(Context var1, double[] var2, boolean var3, int var4, int var5, float var6, float var7, float var8, float var9, int var10);

    abstract void updateRegisterCombiners(Context var1, double[] var2, boolean var3, int var4, int var5, float var6, float var7, float var8, float var9, int var10, int var11, int var12, int[] var13, int[] var14, int[] var15, int[] var16, int var17, int var18);

    abstract void updateTextureColorTable(Context var1, int var2, int var3, int[] var4);

    abstract void updateCombiner(Context var1, int var2, int var3, int[] var4, int[] var5, int[] var6, int[] var7, int var8, int var9);

    abstract void updateTextureUnitState(Context var1, int var2, boolean var3);

    abstract void bindTexture2D(Context var1, int var2, boolean var3);

    abstract void updateTexture2DImage(Context var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, Object var10);

    abstract void updateTexture2DSubImage(Context var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, Object var13);

    abstract void updateTexture2DLodRange(Context var1, int var2, int var3, float var4, float var5);

    abstract void updateTexture2DLodOffset(Context var1, float var2, float var3, float var4);

    abstract void updateTexture2DBoundary(Context var1, int var2, int var3, float var4, float var5, float var6, float var7);

    abstract void updateTexture2DFilterModes(Context var1, int var2, int var3);

    abstract void updateTexture2DSharpenFunc(Context var1, int var2, float[] var3);

    abstract void updateTexture2DFilter4Func(Context var1, int var2, float[] var3);

    abstract void updateTexture2DAnisotropicFilter(Context var1, float var2);

    abstract void bindTexture3D(Context var1, int var2, boolean var3);

    abstract void updateTexture3DImage(Context var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, Object var11);

    abstract void updateTexture3DSubImage(Context var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, Object var17);

    abstract void updateTexture3DLodRange(Context var1, int var2, int var3, float var4, float var5);

    abstract void updateTexture3DLodOffset(Context var1, float var2, float var3, float var4);

    abstract void updateTexture3DBoundary(Context var1, int var2, int var3, int var4, float var5, float var6, float var7, float var8);

    abstract void updateTexture3DFilterModes(Context var1, int var2, int var3);

    abstract void updateTexture3DSharpenFunc(Context var1, int var2, float[] var3);

    abstract void updateTexture3DFilter4Func(Context var1, int var2, float[] var3);

    abstract void updateTexture3DAnisotropicFilter(Context var1, float var2);

    abstract void bindTextureCubeMap(Context var1, int var2, boolean var3);

    abstract void updateTextureCubeMapImage(Context var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, Object var11);

    abstract void updateTextureCubeMapSubImage(Context var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, Object var14);

    abstract void updateTextureCubeMapLodRange(Context var1, int var2, int var3, float var4, float var5);

    abstract void updateTextureCubeMapLodOffset(Context var1, float var2, float var3, float var4);

    abstract void updateTextureCubeMapBoundary(Context var1, int var2, int var3, float var4, float var5, float var6, float var7);

    abstract void updateTextureCubeMapFilterModes(Context var1, int var2, int var3);

    abstract void updateTextureCubeMapSharpenFunc(Context var1, int var2, float[] var3);

    abstract void updateTextureCubeMapFilter4Func(Context var1, int var2, float[] var3);

    abstract void updateTextureCubeMapAnisotropicFilter(Context var1, float var2);

    abstract long getAWT();

    abstract boolean initializeJ3D(boolean var1);

    abstract int getMaximumLights();

    abstract Context createNewContext(Canvas3D var1, long var2, Drawable var4, long var5, Context var7, boolean var8, boolean var9, boolean var10, boolean var11);

    abstract void createQueryContext(Canvas3D var1, long var2, Drawable var4, long var5, boolean var7, int var8, int var9, boolean var10, boolean var11);

    abstract Drawable createOffScreenBuffer(Canvas3D var1, Context var2, long var3, long var5, int var7, int var8);

    abstract void destroyOffScreenBuffer(Canvas3D var1, Context var2, long var3, long var5, Drawable var7);

    abstract void readOffScreenBuffer(Canvas3D var1, Context var2, int var3, int var4, Object var5, int var6, int var7);

    abstract int swapBuffers(Canvas3D var1, Context var2, long var3, Drawable var5);

    abstract int resizeD3DCanvas(Canvas3D var1, Context var2);

    abstract int toggleFullScreenMode(Canvas3D var1, Context var2);

    abstract void updateMaterialColor(Context var1, float var2, float var3, float var4, float var5);

    abstract void destroyContext(long var1, Drawable var3, Context var4);

    abstract void accum(Context var1, float var2);

    abstract void accumReturn(Context var1);

    abstract void clearAccum(Context var1);

    abstract int getNumCtxLights(Context var1);

    abstract boolean decal1stChildSetup(Context var1);

    abstract void decalNthChildSetup(Context var1);

    abstract void decalReset(Context var1, boolean var2);

    abstract void ctxUpdateEyeLightingEnable(Context var1, boolean var2);

    abstract void setBlendColor(Context var1, float var2, float var3, float var4, float var5);

    abstract void setBlendFunc(Context var1, int var2, int var3);

    abstract void setFogEnableFlag(Context var1, boolean var2);

    abstract void setFullSceneAntialiasing(Context var1, boolean var2);

    abstract void setGlobalAlpha(Context var1, float var2);

    abstract void updateSeparateSpecularColorEnable(Context var1, boolean var2);

    abstract void beginScene(Context var1);

    abstract void endScene(Context var1);

    abstract boolean validGraphicsMode();

    abstract void setLightEnables(Context var1, long var2, int var4);

    abstract void setSceneAmbient(Context var1, float var2, float var3, float var4);

    abstract void disableFog(Context var1);

    abstract void disableModelClip(Context var1);

    abstract void resetRenderingAttributes(Context var1, boolean var2, boolean var3);

    abstract void resetTextureNative(Context var1, int var2);

    abstract void activeTextureUnit(Context var1, int var2);

    abstract void resetTexCoordGeneration(Context var1);

    abstract void resetTextureAttributes(Context var1);

    abstract void resetPolygonAttributes(Context var1);

    abstract void resetLineAttributes(Context var1);

    abstract void resetPointAttributes(Context var1);

    abstract void resetTransparency(Context var1, int var2, int var3, boolean var4, boolean var5);

    abstract void resetColoringAttributes(Context var1, float var2, float var3, float var4, float var5, boolean var6);

    abstract void syncRender(Context var1, boolean var2);

    abstract boolean useCtx(Context var1, long var2, Drawable var4);

    boolean releaseCtx(Context context, long l) {
        return false;
    }

    abstract void clear(Context var1, float var2, float var3, float var4);

    abstract void textureFillBackground(Context var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9);

    abstract void textureFillRaster(Context var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11);

    abstract void executeRasterDepth(Context var1, float var2, float var3, float var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, Object var12);

    abstract void setModelViewMatrix(Context var1, double[] var2, double[] var3);

    abstract void setProjectionMatrix(Context var1, double[] var2);

    abstract void setViewport(Context var1, int var2, int var3, int var4, int var5);

    abstract void newDisplayList(Context var1, int var2);

    abstract void endDisplayList(Context var1);

    abstract void callDisplayList(Context var1, int var2, boolean var3);

    abstract void freeDisplayList(Context var1, int var2);

    abstract void freeTexture(Context var1, int var2);

    abstract void texturemapping(Context var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, byte[] var13, int var14, int var15);

    abstract boolean initTexturemapping(Context var1, int var2, int var3, int var4);

    abstract void setRenderMode(Context var1, int var2, boolean var3);

    abstract void setDepthBufferWriteEnable(Context var1, boolean var2);

    abstract GraphicsConfiguration getGraphicsConfig(GraphicsConfiguration var1);

    abstract long getFbConfig(GraphicsConfigInfo var1);

    abstract GraphicsConfiguration getBestConfiguration(GraphicsConfigTemplate3D var1, GraphicsConfiguration[] var2);

    abstract boolean isGraphicsConfigSupported(GraphicsConfigTemplate3D var1, GraphicsConfiguration var2);

    abstract boolean hasDoubleBuffer(Canvas3D var1);

    abstract boolean hasStereo(Canvas3D var1);

    abstract int getStencilSize(Canvas3D var1);

    abstract boolean hasSceneAntialiasingMultisample(Canvas3D var1);

    abstract boolean hasSceneAntialiasingAccum(Canvas3D var1);

    abstract long getDisplay();

    abstract int getScreen(GraphicsDevice var1);

    abstract DrawingSurfaceObject createDrawingSurfaceObject(Canvas3D var1);

    abstract void freeDrawingSurface(Canvas3D var1, DrawingSurfaceObject var2);

    abstract void freeDrawingSurfaceNative(Object var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        NATIVE_OGL,
        NATIVE_D3D,
        JOGL,
        NOOP;

    }
}

