/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.GeomBuffer;
import com.sun.j3d.utils.geometry.Primitive;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Vector3f;

public class Sphere
extends Primitive {
    public static final int BODY = 0;
    static final int MID_REZ_DIV = 16;
    float radius;
    int divisions;

    public Sphere(float f) {
        this(f, 1, 16);
    }

    public Sphere() {
        this(1.0f, 1, 16);
    }

    public Sphere(float f, Appearance appearance) {
        this(f, 1, 16, appearance);
    }

    public Sphere(float f, int n, Appearance appearance) {
        this(f, n, 16, appearance);
    }

    public Sphere(float f, int n, int n2) {
        this(f, n, n2, null);
    }

    public Shape3D getShape(int n) {
        if (n != 0) {
            return null;
        }
        return (Shape3D)this.getChild(0);
    }

    public Shape3D getShape() {
        return (Shape3D)this.getChild(0);
    }

    public void setAppearance(Appearance appearance) {
        ((Shape3D)this.getChild(0)).setAppearance(appearance);
    }

    public Appearance getAppearance(int n) {
        if (n != 0) {
            return null;
        }
        return this.getShape(n).getAppearance();
    }

    public Sphere(float f, int n, int n2, Appearance appearance) {
        Shape3D shape3D;
        int n3;
        int n4;
        this.radius = f;
        this.divisions = n2;
        this.flags = n;
        int n5 = (this.flags & 4) != 0 ? -1 : 1;
        if (n2 < 4) {
            n4 = 1;
            n3 = 4;
        } else {
            int n6 = n2 % 4;
            n3 = n6 == 0 ? n2 : n2 + (4 - n6);
            n4 = n3 / 4;
        }
        GeomBuffer geomBuffer = this.getCachedGeometry(1, f, 0.0f, 0.0f, n2, 0, n);
        if (geomBuffer != null) {
            shape3D = new Shape3D((Geometry)geomBuffer.getComputedGeometry());
            this.numVerts += geomBuffer.getNumVerts();
            this.numTris += geomBuffer.getNumTris();
        } else {
            GeomBuffer geomBuffer2 = new GeomBuffer(8 * n4 * (n4 + 2));
            for (int i = 0; i < 4; ++i) {
                this.buildQuadrant(geomBuffer2, (double)i * Math.PI / 2.0, (double)(i + 1) * Math.PI / 2.0, n5, n4, n3, true);
                this.buildQuadrant(geomBuffer2, (double)i * Math.PI / 2.0, (double)(i + 1) * Math.PI / 2.0, n5, n4, n3, false);
            }
            shape3D = new Shape3D((Geometry)geomBuffer2.getGeom(this.flags));
            this.numVerts = geomBuffer2.getNumVerts();
            this.numTris = geomBuffer2.getNumTris();
            if ((n & 0x10) == 0) {
                this.cacheGeometry(1, f, 0.0f, 0.0f, n2, 0, n, geomBuffer2);
            }
        }
        if ((this.flags & 0x40) != 0) {
            shape3D.setCapability(14);
            shape3D.setCapability(15);
        }
        if ((this.flags & 0x20) != 0) {
            shape3D.setCapability(12);
        }
        this.addChild((Node)shape3D);
        if (appearance == null) {
            this.setAppearance();
        } else {
            this.setAppearance(appearance);
        }
    }

    public Node cloneNode(boolean bl) {
        Sphere sphere = new Sphere(this.radius, this.flags, this.divisions, this.getAppearance());
        sphere.duplicateNode((Node)this, bl);
        return sphere;
    }

    public void duplicateNode(Node node, boolean bl) {
        super.duplicateNode(node, bl);
    }

    public float getRadius() {
        return this.radius;
    }

    public int getDivisions() {
        return this.divisions;
    }

    void buildQuadrant(GeomBuffer geomBuffer, double d, double d2, int n, int n2, int n3, boolean bl) {
        boolean bl2;
        double d3;
        double d4;
        double d5;
        if (bl) {
            d4 = d5 = Math.PI / (double)(2 * n2);
            d3 = 1.0;
            bl2 = n > 0;
        } else {
            d5 = -Math.PI / (double)(2 * n2);
            d4 = Math.PI + d5;
            d3 = -1.0;
            bl2 = n < 0;
        }
        for (int i = 1; i <= n2; ++i) {
            TexCoord2f texCoord2f;
            Vector3f vector3f;
            Point3f point3f;
            int n4;
            double d6;
            double d7;
            int n5;
            double d8;
            double d9 = Math.cos(d4);
            double d10 = Math.sin(d4);
            double d11 = n > 0 ? 1.0 - d4 / Math.PI : d4 / Math.PI;
            int n6 = i << 1;
            double d12 = (d2 - d) / (double)i;
            geomBuffer.begin(32);
            if (bl2) {
                d8 = d;
                for (n5 = 0; n5 < i; ++n5) {
                    d7 = d10 * Math.cos(d8);
                    d6 = d10 * Math.sin(d8);
                    geomBuffer.normal3d(d7 * (double)n, d9 * (double)n, d6 * (double)n);
                    geomBuffer.texCoord2d(0.75 - d8 / (Math.PI * 2), d11);
                    geomBuffer.vertex3d(d7 * (double)this.radius, d9 * (double)this.radius, d6 * (double)this.radius);
                    if (i > 1) {
                        n4 = geomBuffer.currVertCnt - n6;
                        point3f = geomBuffer.pts[n4];
                        vector3f = geomBuffer.normals[n4];
                        texCoord2f = geomBuffer.tcoords[n4];
                        geomBuffer.normal3d(vector3f.x, vector3f.y, vector3f.z);
                        geomBuffer.texCoord2d(texCoord2f.x, texCoord2f.y);
                        geomBuffer.vertex3d(point3f.x, point3f.y, point3f.z);
                    } else {
                        geomBuffer.normal3d(0.0, (double)n * d3, 0.0);
                        if (n > 0) {
                            geomBuffer.texCoord2d(0.75 - (d + d2) / (Math.PI * 4), 1.0 - (d4 - d5) / Math.PI);
                        } else {
                            geomBuffer.texCoord2d(0.75 - (d + d2) / (Math.PI * 4), (d4 - d5) / Math.PI);
                        }
                        geomBuffer.vertex3d(0.0, d3 * (double)this.radius, 0.0);
                    }
                    d8 += d12;
                }
                d8 = d2;
                d7 = d10 * Math.cos(d8);
                d6 = d10 * Math.sin(d8);
                geomBuffer.normal3d(d7 * (double)n, d9 * (double)n, d6 * (double)n);
                geomBuffer.texCoord2d(0.75 - d8 / (Math.PI * 2), d11);
                geomBuffer.vertex3d(d7 * (double)this.radius, d9 * (double)this.radius, d6 * (double)this.radius);
            } else {
                d8 = d2;
                for (n5 = i; n5 > 0; --n5) {
                    d7 = d10 * Math.cos(d8);
                    d6 = d10 * Math.sin(d8);
                    geomBuffer.normal3d(d7 * (double)n, d9 * (double)n, d6 * (double)n);
                    geomBuffer.texCoord2d(0.75 - d8 / (Math.PI * 2), d11);
                    geomBuffer.vertex3d(d7 * (double)this.radius, d9 * (double)this.radius, d6 * (double)this.radius);
                    if (i > 1) {
                        n4 = geomBuffer.currVertCnt - n6;
                        point3f = geomBuffer.pts[n4];
                        vector3f = geomBuffer.normals[n4];
                        texCoord2f = geomBuffer.tcoords[n4];
                        geomBuffer.normal3d(vector3f.x, vector3f.y, vector3f.z);
                        geomBuffer.texCoord2d(texCoord2f.x, texCoord2f.y);
                        geomBuffer.vertex3d(point3f.x, point3f.y, point3f.z);
                    } else {
                        geomBuffer.normal3d(0.0, (double)n * d3, 0.0);
                        if (n > 0) {
                            geomBuffer.texCoord2d(0.75 - (d + d2) / (Math.PI * 4), 1.0 - (d4 - d5) / Math.PI);
                        } else {
                            geomBuffer.texCoord2d(0.75 - (d + d2) / (Math.PI * 4), (d4 - d5) / Math.PI);
                        }
                        geomBuffer.vertex3d(0.0, d3 * (double)this.radius, 0.0);
                    }
                    d8 -= d12;
                }
                d8 = d;
                d7 = d10 * Math.cos(d8);
                d6 = d10 * Math.sin(d8);
                geomBuffer.normal3d(d7 * (double)n, d9 * (double)n, d6 * (double)n);
                geomBuffer.texCoord2d(0.75 - d8 / (Math.PI * 2), d11);
                geomBuffer.vertex3d(d7 * (double)this.radius, d9 * (double)this.radius, d6 * (double)this.radius);
            }
            geomBuffer.end();
            if (i < n2) {
                d4 += d5;
                continue;
            }
            d4 = 1.5707963267948966;
        }
    }
}

