/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.io.connection;

import com.romraider.io.connection.ConnectionManager;
import com.romraider.io.connection.ConnectionProperties;
import com.romraider.io.j2534.api.J2534ConnectionManager;
import com.romraider.io.serial.connection.SerialConnectionManager;
import org.apache.log4j.Logger;

public final class ConnectionManagerFactory {
    private static final Logger LOGGER = Logger.getLogger(ConnectionManagerFactory.class);
    private static final boolean ENABLE_TIMER = false;

    private ConnectionManagerFactory() {
    }

    public static ConnectionManager getManager(String string, ConnectionProperties connectionProperties) {
        ConnectionManager connectionManager = ConnectionManagerFactory.manager(string, connectionProperties);
        return connectionManager;
    }

    private static ConnectionManager manager(String string, ConnectionProperties connectionProperties) {
        try {
            return new J2534ConnectionManager(connectionProperties);
        }
        catch (Throwable throwable) {
            LOGGER.info((Object)("J2534 connection not available [" + throwable.getClass().getName() + ": " + throwable.getMessage() + "], trying serial connection..."));
            return new SerialConnectionManager(string, connectionProperties);
        }
    }
}

