/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.io.j2534.api;

import com.romraider.io.connection.ConnectionManager;
import com.romraider.io.connection.ConnectionProperties;
import com.romraider.io.j2534.api.ConfigItem;
import com.romraider.io.j2534.api.J2534;
import com.romraider.io.j2534.api.J2534Exception;
import com.romraider.io.j2534.api.Version;
import com.romraider.io.j2534.op20.Old_J2534OpenPort20;
import com.romraider.util.ParamChecker;
import org.apache.log4j.Logger;

public final class J2534ConnectionManager
implements ConnectionManager {
    private static final Logger LOGGER = Logger.getLogger(J2534ConnectionManager.class);
    private final J2534 api = new Old_J2534OpenPort20(3);
    private int channelId;
    private int deviceId;
    private int msgId;

    public J2534ConnectionManager(ConnectionProperties connectionProperties) {
        ParamChecker.checkNotNull((Object)connectionProperties, "connectionProperties");
        this.initJ2534(connectionProperties.getBaudRate());
        LOGGER.info((Object)"J2534 connection initialised");
    }

    public void send(byte[] byArray, byte[] byArray2, long l) {
        ParamChecker.checkNotNull((Object)byArray, "request");
        ParamChecker.checkNotNull((Object)byArray, "response");
        this.api.writeMsg(this.channelId, byArray, l);
        this.api.readMsg(this.channelId, byArray2, l);
    }

    public byte[] send(byte[] byArray, long l) {
        ParamChecker.checkNotNull((Object)byArray, "request");
        this.api.writeMsg(this.channelId, byArray, l);
        return this.api.readMsg(this.channelId, l);
    }

    public void close() {
        this.stopMsgFilter();
        this.disconnectChannel();
        this.closeDevice();
        this.resetHandles();
        LOGGER.info((Object)"J2534 connection closed");
    }

    private void initJ2534(int n) {
        this.deviceId = this.api.open();
        try {
            this.version(this.deviceId);
            this.channelId = this.api.connect(this.deviceId, 512, n);
            this.setConfig(this.channelId);
            this.msgId = this.api.startPassMsgFilter(this.channelId, (byte)0, (byte)0);
        }
        catch (Exception exception) {
            this.close();
            throw new J2534Exception("Error during J2534 init: " + exception.getMessage(), exception);
        }
    }

    private void version(int n) {
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        Version version = this.api.readVersion(n);
        LOGGER.info((Object)("J2534 Version => firmware: " + version.firmware + ", dll: " + version.dll + ", api: " + version.api));
    }

    private void setConfig(int n) {
        ConfigItem configItem = new ConfigItem(7, 2);
        ConfigItem configItem2 = new ConfigItem(10, 0);
        ConfigItem configItem3 = new ConfigItem(12, 0);
        ConfigItem configItem4 = new ConfigItem(3, 1);
        this.api.setConfig(n, configItem, configItem2, configItem3, configItem4);
    }

    private void stopMsgFilter() {
        try {
            if (this.channelId > 0 && this.msgId > 0) {
                this.api.stopMsgFilter(this.channelId, this.msgId);
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("Error stopping msg filter: " + exception.getMessage()));
        }
    }

    private void disconnectChannel() {
        try {
            if (this.channelId > 0) {
                this.api.disconnect(this.channelId);
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("Error disconnecting channel: " + exception.getMessage()));
        }
    }

    private void closeDevice() {
        try {
            if (this.deviceId > 0) {
                this.api.close(this.deviceId);
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("Error closing device: " + exception.getMessage()));
        }
    }

    private void resetHandles() {
        this.channelId = 0;
        this.deviceId = 0;
        this.msgId = 0;
    }
}

