/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.io.j2534.api;

import com.romraider.io.j2534.api.ConfigItem;
import com.romraider.io.j2534.api.J2534;
import com.romraider.io.j2534.api.Version;
import com.romraider.io.j2534.op20.Old_J2534OpenPort20;
import com.romraider.util.HexUtil;
import com.romraider.util.LogManager;

public final class TestJ2534 {
    private static final J2534 api = new Old_J2534OpenPort20(3);

    public static void main(String[] stringArray) {
        LogManager.initDebugLogging();
        TestJ2534.ecuInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ecuInit() {
        int n = api.open();
        try {
            TestJ2534.version(n);
            int n2 = api.connect(n, 512, 4800);
            try {
                TestJ2534.setConfig(n2);
                int n3 = api.startPassMsgFilter(n2, (byte)0, (byte)0);
                try {
                    byte[] byArray = new byte[]{-128, 16, -16, 1, -65, 64};
                    api.writeMsg(n2, byArray, 55L);
                    System.out.println("Request  = " + HexUtil.asHex(byArray));
                    byte[] byArray2 = api.readMsg(n2, 2000L);
                    System.out.println("Response = " + HexUtil.asHex(byArray2));
                }
                finally {
                    api.stopMsgFilter(n2, n3);
                }
            }
            finally {
                api.disconnect(n2);
            }
        }
        finally {
            api.close(n);
        }
    }

    private static void version(int n) {
        Version version = api.readVersion(n);
        System.out.println("Version => firmware: " + version.firmware + ", dll: " + version.dll + ", api: " + version.api);
    }

    private static void setConfig(int n) {
        ConfigItem configItem = new ConfigItem(7, 2);
        ConfigItem configItem2 = new ConfigItem(10, 0);
        ConfigItem configItem3 = new ConfigItem(12, 0);
        ConfigItem configItem4 = new ConfigItem(3, 1);
        api.setConfig(n, configItem, configItem2, configItem3, configItem4);
    }
}

