/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.io.j2534.op20;

import com.romraider.io.j2534.api.ConfigItem;
import com.romraider.io.j2534.api.J2534;
import com.romraider.io.j2534.api.J2534Exception;
import com.romraider.io.j2534.api.Version;
import com.romraider.io.j2534.op20.J2534OpenPort20;
import com.romraider.io.j2534.op20.OpenPort20;
import com.romraider.io.j2534.op20.PassThruMessage;
import com.romraider.io.j2534.op20.SConfig;
import com.romraider.io.j2534.op20.SConfigList;
import com.romraider.util.HexUtil;
import com.romraider.util.ThreadUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Old_J2534OpenPort20
implements J2534 {
    private static final Logger LOGGER = Logger.getLogger(J2534OpenPort20.class);
    private final int protocol;

    public Old_J2534OpenPort20(int n) {
        this.protocol = n;
    }

    @Override
    public int open() {
        int[] nArray = new int[]{0};
        int n = OpenPort20.PassThruOpen(null, nArray);
        if (n != 0) {
            this.handleError(n);
        }
        return nArray[0];
    }

    @Override
    public Version readVersion(int n) {
        byte[] byArray = new byte[80];
        byte[] byArray2 = new byte[80];
        byte[] byArray3 = new byte[80];
        int n2 = OpenPort20.PassThruReadVersion(n, byArray, byArray2, byArray3);
        if (n2 != 0) {
            this.handleError(n2);
        }
        return new Version(this.toString(byArray), this.toString(byArray2), this.toString(byArray3));
    }

    @Override
    public int connect(int n, int n2, int n3) {
        int[] nArray = new int[]{0};
        int n4 = OpenPort20.PassThruConnect(n, this.protocol, n2, n3, nArray);
        if (n4 != 0) {
            this.handleError(n4);
        }
        return nArray[0];
    }

    @Override
    public void setConfig(int n, ConfigItem ... configItemArray) {
        if (configItemArray.length == 0) {
            return;
        }
        SConfig[] sConfigArray = this.sConfigs(configItemArray);
        SConfigList sConfigList = this.sConfigList(sConfigArray);
        int n2 = OpenPort20.PassThruIoctl(n, 2, sConfigList, null);
        if (n2 != 0) {
            this.handleError(n2);
        }
    }

    @Override
    public ConfigItem[] getConfig(int n, int ... nArray) {
        if (nArray.length == 0) {
            return this.configItems(new SConfig[0]);
        }
        SConfig[] sConfigArray = this.sConfigs(nArray);
        SConfigList sConfigList = this.sConfigList(sConfigArray);
        int n2 = OpenPort20.PassThruIoctl(n, 1, sConfigList, null);
        if (n2 != 0) {
            this.handleError(n2);
        }
        return this.configItems(sConfigList.ConfigPtr);
    }

    @Override
    public int startPassMsgFilter(int n, byte by, byte by2) {
        PassThruMessage passThruMessage = this.passThruMessage(by);
        PassThruMessage passThruMessage2 = this.passThruMessage(by2);
        int[] nArray = new int[]{0};
        int n2 = OpenPort20.PassThruStartMsgFilter(n, 1, passThruMessage, passThruMessage2, null, nArray);
        if (n2 != 0) {
            this.handleError(n2);
        }
        return nArray[0];
    }

    @Override
    public void writeMsg(int n, byte[] byArray, long l) {
        PassThruMessage passThruMessage = this.passThruMessage(byArray);
        LOGGER.trace((Object)("Write Msg: " + this.toString(passThruMessage)));
        int[] nArray = new int[]{1};
        int n2 = OpenPort20.PassThruWriteMsgs(n, passThruMessage, nArray, (int)l);
        if (n2 != 0) {
            this.handleError(n2);
        }
    }

    @Override
    public void readMsg(int n, byte[] byArray, long l) {
        int n2 = 0;
        long l2 = System.currentTimeMillis() + l;
        do {
            PassThruMessage passThruMessage = this.doReadMsg(n);
            LOGGER.trace((Object)("Read Msg: " + this.toString(passThruMessage)));
            if (!this.isResponse(passThruMessage)) continue;
            System.arraycopy(passThruMessage.Data, 0, byArray, n2, passThruMessage.DataSize);
            n2 += passThruMessage.DataSize;
        } while (System.currentTimeMillis() <= l2 && n2 < byArray.length - 1);
    }

    @Override
    public byte[] readMsg(int n, long l) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        long l2 = System.currentTimeMillis() + l;
        do {
            PassThruMessage passThruMessage = this.doReadMsg(n);
            LOGGER.trace((Object)("Read Msg: " + this.toString(passThruMessage)));
            if (this.isResponse(passThruMessage)) {
                arrayList.add(this.data(passThruMessage));
            }
            ThreadUtil.sleep(2L);
        } while (System.currentTimeMillis() <= l2);
        return this.concat(arrayList);
    }

    private byte[] concat(List<byte[]> list) {
        int n = 0;
        for (byte[] byArray : list) {
            n += byArray.length;
        }
        Object object = new byte[n];
        int n2 = 0;
        for (byte[] byArray : list) {
            if (byArray.length == 0) continue;
            System.arraycopy(byArray, 0, object, n2, byArray.length);
            n2 += byArray.length;
        }
        return object;
    }

    private String toString(PassThruMessage passThruMessage) {
        byte[] byArray = new byte[passThruMessage.DataSize];
        System.arraycopy(passThruMessage.Data, 0, byArray, 0, byArray.length);
        return "[ProtocolID=" + passThruMessage.ProtocolID + "|RxStatus=" + passThruMessage.RxStatus + "|TxFlags=" + passThruMessage.TxFlags + "|Timestamp=" + passThruMessage.Timestamp + "|ExtraDataIndex=" + passThruMessage.ExtraDataIndex + "|DataSize=" + passThruMessage.DataSize + "|Data=" + HexUtil.asHex(byArray) + "]";
    }

    private boolean isResponse(PassThruMessage passThruMessage) {
        if (passThruMessage.Timestamp == 0) {
            return false;
        }
        if (passThruMessage.RxStatus == 0) {
            return true;
        }
        return passThruMessage.RxStatus == 1;
    }

    private PassThruMessage doReadMsg(int n) {
        int[] nArray;
        PassThruMessage passThruMessage = this.passThruMessage();
        int n2 = OpenPort20.PassThruReadMsgs(n, passThruMessage, nArray = new int[]{1}, 0);
        if (n2 != 0 && n2 != 9) {
            this.handleError(n2);
        }
        return passThruMessage;
    }

    @Override
    public void stopMsgFilter(int n, int n2) {
        int n3 = OpenPort20.PassThruStopMsgFilter(n, n2);
        if (n3 != 0) {
            this.handleError(n3);
        }
    }

    @Override
    public void disconnect(int n) {
        int n2 = OpenPort20.PassThruDisconnect(n);
        if (n2 != 0) {
            this.handleError(n2);
        }
    }

    @Override
    public void close(int n) {
        int n2 = OpenPort20.PassThruClose(n);
        if (n2 != 0) {
            this.handleError(n2);
        }
    }

    private ConfigItem[] configItems(SConfig ... sConfigArray) {
        ConfigItem[] configItemArray = new ConfigItem[sConfigArray.length];
        for (int i = 0; i < sConfigArray.length; ++i) {
            SConfig sConfig = sConfigArray[i];
            configItemArray[i] = new ConfigItem(sConfig.Parameter, sConfig.Value);
        }
        return configItemArray;
    }

    private SConfig[] sConfigs(ConfigItem ... configItemArray) {
        SConfig[] sConfigArray = new SConfig[configItemArray.length];
        for (int i = 0; i < configItemArray.length; ++i) {
            SConfig sConfig = new SConfig();
            sConfig.Parameter = configItemArray[i].parameter;
            sConfig.Value = configItemArray[i].value;
            sConfigArray[i] = sConfig;
        }
        return sConfigArray;
    }

    private SConfig[] sConfigs(int ... nArray) {
        SConfig[] sConfigArray = new SConfig[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            SConfig sConfig = new SConfig();
            sConfig.Parameter = nArray[i];
            sConfigArray[i] = sConfig;
        }
        return sConfigArray;
    }

    private SConfigList sConfigList(SConfig[] sConfigArray) {
        SConfigList sConfigList = new SConfigList();
        sConfigList.NumOfParams = sConfigArray.length;
        sConfigList.ConfigPtr = sConfigArray;
        return sConfigList;
    }

    private PassThruMessage passThruMessage(byte ... byArray) {
        PassThruMessage passThruMessage = this.passThruMessage();
        System.arraycopy(byArray, 0, passThruMessage.Data, 0, byArray.length);
        passThruMessage.DataSize = byArray.length;
        return passThruMessage;
    }

    private PassThruMessage passThruMessage() {
        PassThruMessage passThruMessage = new PassThruMessage();
        passThruMessage.ProtocolID = this.protocol;
        return passThruMessage;
    }

    private byte[] data(PassThruMessage passThruMessage) {
        int n = passThruMessage.DataSize;
        byte[] byArray = new byte[n];
        System.arraycopy(passThruMessage.Data, 0, byArray, 0, n);
        return byArray;
    }

    private void handleError(int n) {
        byte[] byArray = new byte[80];
        OpenPort20.PassThruGetLastError(byArray);
        throw new J2534Exception("Error: [" + n + "] " + this.toString(byArray));
    }

    private String toString(byte[] byArray) {
        String string = "";
        for (byte by : byArray) {
            if (by == 0) continue;
            string = string + (char)by;
        }
        return string;
    }
}

