/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.comms.controller;

import com.romraider.Settings;
import com.romraider.logger.ecu.comms.controller.LoggerController;
import com.romraider.logger.ecu.comms.manager.QueryManager;
import com.romraider.logger.ecu.comms.manager.QueryManagerImpl;
import com.romraider.logger.ecu.comms.query.EcuInitCallback;
import com.romraider.logger.ecu.definition.LoggerData;
import com.romraider.logger.ecu.ui.MessageListener;
import com.romraider.logger.ecu.ui.StatusChangeListener;
import com.romraider.logger.ecu.ui.handler.DataUpdateHandler;
import com.romraider.logger.ecu.ui.handler.file.FileLoggerControllerSwitchMonitor;
import com.romraider.util.ParamChecker;
import com.romraider.util.ThreadUtil;
import org.apache.log4j.Logger;

public final class LoggerControllerImpl
implements LoggerController {
    private static final Logger LOGGER = Logger.getLogger(LoggerControllerImpl.class);
    private final QueryManager queryManager;

    public LoggerControllerImpl(Settings settings, EcuInitCallback ecuInitCallback, MessageListener messageListener, DataUpdateHandler ... dataUpdateHandlerArray) {
        ParamChecker.checkNotNull(settings, ecuInitCallback, messageListener, dataUpdateHandlerArray);
        this.queryManager = new QueryManagerImpl(settings, ecuInitCallback, messageListener, dataUpdateHandlerArray);
    }

    public synchronized void addListener(StatusChangeListener statusChangeListener) {
        ParamChecker.checkNotNull((Object)statusChangeListener, "listener");
        this.queryManager.addListener(statusChangeListener);
    }

    public void setFileLoggerSwitchMonitor(FileLoggerControllerSwitchMonitor fileLoggerControllerSwitchMonitor) {
        ParamChecker.checkNotNull(fileLoggerControllerSwitchMonitor);
        LOGGER.debug((Object)("Setting file logger switch monitor: [" + fileLoggerControllerSwitchMonitor.getEcuSwitch().getId() + "] " + fileLoggerControllerSwitchMonitor.getEcuSwitch().getName()));
        this.queryManager.setFileLoggerSwitchMonitor(fileLoggerControllerSwitchMonitor);
    }

    public void addLogger(String string, LoggerData loggerData) {
        ParamChecker.checkNotNull(loggerData);
        LOGGER.debug((Object)("Adding logger:   [" + loggerData.getId() + "] " + loggerData.getName()));
        this.queryManager.addQuery(string, loggerData);
    }

    public void removeLogger(String string, LoggerData loggerData) {
        ParamChecker.checkNotNull((Object)loggerData, "ecuParam");
        LOGGER.debug((Object)("Removing logger: [" + loggerData.getId() + "] " + loggerData.getName()));
        this.queryManager.removeQuery(string, loggerData);
    }

    public synchronized boolean isStarted() {
        return this.queryManager.isRunning();
    }

    public synchronized void start() {
        if (!this.isStarted()) {
            ThreadUtil.runAsDaemon(this.queryManager);
        }
    }

    public synchronized void stop() {
        if (this.isStarted()) {
            this.queryManager.stop();
        }
    }
}

