/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.definition;

import com.romraider.logger.ecu.definition.EcuAddress;
import com.romraider.util.HexUtil;
import com.romraider.util.ParamChecker;
import java.util.LinkedList;

public final class EcuAddressImpl
implements EcuAddress {
    private final String[] addresses;
    private final byte[] bytes;
    private final int bit;

    public EcuAddressImpl(String string, int n, int n2) {
        ParamChecker.checkNotNullOrEmpty(string, "address");
        ParamChecker.checkGreaterThanZero(n, "length");
        this.addresses = this.buildAddresses(string, n);
        this.bytes = this.getAddressBytes(this.addresses);
        this.bit = n2;
    }

    public EcuAddressImpl(String[] stringArray) {
        ParamChecker.checkNotNullOrEmpty(stringArray, "addresses");
        this.addresses = stringArray;
        this.bytes = this.getAddressBytes(stringArray);
        this.bit = -1;
    }

    public String[] getAddresses() {
        return this.addresses;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getBit() {
        return this.bit;
    }

    public int getLength() {
        return this.addresses.length;
    }

    private String[] buildAddresses(String string, int n) {
        LinkedList<String> linkedList = new LinkedList<String>();
        int n2 = HexUtil.hexToInt(string);
        for (int i = 0; i < n; ++i) {
            linkedList.add(this.padAddress(HexUtil.intToHexString(n2 + i), string.length()));
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    private String padAddress(String string, int n) {
        if (string.length() == n) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        stringBuilder.append("0x");
        String string2 = string.substring(2);
        for (int i = 0; i < n - string2.length() - 2; ++i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private byte[] getAddressBytes(String[] stringArray) {
        byte[] byArray = new byte[]{};
        for (String string : stringArray) {
            byte[] byArray2 = HexUtil.asBytes(string);
            byte[] byArray3 = new byte[byArray.length + byArray2.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
            byArray = byArray3;
        }
        return byArray;
    }
}

