/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.definition;

import com.romraider.io.connection.ConnectionProperties;
import com.romraider.logger.ecu.comms.query.EcuInit;
import com.romraider.logger.ecu.definition.EcuDataLoader;
import com.romraider.logger.ecu.definition.EcuDefinition;
import com.romraider.logger.ecu.definition.EcuParameter;
import com.romraider.logger.ecu.definition.EcuSwitch;
import com.romraider.logger.ecu.definition.xml.EcuDefinitionHandler;
import com.romraider.logger.ecu.definition.xml.LoggerDefinitionHandler;
import com.romraider.logger.ecu.exception.ConfigurationException;
import com.romraider.util.ParamChecker;
import com.romraider.util.SaxParserFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EcuDataLoaderImpl
implements EcuDataLoader {
    private Map<String, EcuDefinition> ecuDefinitionMap = new HashMap<String, EcuDefinition>();
    private List<EcuParameter> ecuParameters = new ArrayList<EcuParameter>();
    private List<EcuSwitch> ecuSwitches = new ArrayList<EcuSwitch>();
    private EcuSwitch fileLoggingControllerSwitch;
    private ConnectionProperties connectionProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadEcuDefsFromXml(File file) {
        ParamChecker.checkNotNull((Object)file, "ecuDefsFile");
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            try {
                EcuDefinitionHandler ecuDefinitionHandler = new EcuDefinitionHandler();
                SaxParserFactory.getSaxParser().parse((InputStream)bufferedInputStream, (DefaultHandler)ecuDefinitionHandler);
                this.ecuDefinitionMap = ecuDefinitionHandler.getEcuDefinitionMap();
            }
            finally {
                ((InputStream)bufferedInputStream).close();
            }
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadConfigFromXml(String string, String string2, String string3, EcuInit ecuInit) {
        ParamChecker.checkNotNullOrEmpty(string, "loggerConfigFilePath");
        ParamChecker.checkNotNullOrEmpty(string2, "protocol");
        ParamChecker.checkNotNullOrEmpty(string3, "fileLoggingControllerSwitchId");
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(new File(string)));
            try {
                LoggerDefinitionHandler loggerDefinitionHandler = new LoggerDefinitionHandler(string2, string3, ecuInit);
                SaxParserFactory.getSaxParser().parse((InputStream)bufferedInputStream, (DefaultHandler)loggerDefinitionHandler);
                this.ecuParameters = loggerDefinitionHandler.getEcuParameters();
                this.ecuSwitches = loggerDefinitionHandler.getEcuSwitches();
                this.fileLoggingControllerSwitch = loggerDefinitionHandler.getFileLoggingControllerSwitch();
                this.connectionProperties = loggerDefinitionHandler.getConnectionProperties();
            }
            finally {
                ((InputStream)bufferedInputStream).close();
            }
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception);
        }
    }

    @Override
    public Map<String, EcuDefinition> getEcuDefinitionMap() {
        return this.ecuDefinitionMap;
    }

    @Override
    public List<EcuParameter> getEcuParameters() {
        return this.ecuParameters;
    }

    @Override
    public List<EcuSwitch> getEcuSwitches() {
        return this.ecuSwitches;
    }

    @Override
    public EcuSwitch getFileLoggingControllerSwitch() {
        return this.fileLoggingControllerSwitch;
    }

    @Override
    public ConnectionProperties getConnectionProperties() {
        return this.connectionProperties;
    }
}

