/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.definition;

import com.romraider.logger.ecu.definition.EcuData;
import com.romraider.logger.ecu.definition.EcuDataConvertor;
import com.romraider.logger.ecu.definition.EcuDerivedParameterConvertor;
import com.romraider.logger.ecu.ui.handler.dash.GaugeMinMax;
import com.romraider.util.JEPUtil;
import com.romraider.util.ParamChecker;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EcuDerivedParameterConvertorImpl
implements EcuDerivedParameterConvertor {
    private EcuData[] ecuDatas;
    private final String units;
    private final String expression;
    private final DecimalFormat format;
    private final Map<String, String> replaceMap;
    private final Map<String, ExpressionInfo> expressionInfoMap = Collections.synchronizedMap(new HashMap());
    private final GaugeMinMax gaugeMinMax;

    public EcuDerivedParameterConvertorImpl(String string, String string2, String string3, Map<String, String> map, GaugeMinMax gaugeMinMax) {
        ParamChecker.checkNotNullOrEmpty(string, "units");
        ParamChecker.checkNotNullOrEmpty(string2, "expression");
        ParamChecker.checkNotNullOrEmpty(string3, "format");
        ParamChecker.checkNotNull(map, "replaceMap");
        ParamChecker.checkNotNull((Object)gaugeMinMax, "gaugeMinMax");
        this.units = string;
        this.expression = string2;
        this.format = new DecimalFormat(string3);
        this.replaceMap = map;
        this.gaugeMinMax = gaugeMinMax;
    }

    @Override
    public double convert(byte[] byArray) {
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        String string = this.expression;
        int n = 0;
        for (EcuData ecuData : this.ecuDatas) {
            int n2 = ecuData.getAddress().getLength();
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            ExpressionInfo expressionInfo = this.expressionInfoMap.get(ecuData.getId());
            hashMap.put(expressionInfo.getReplacementKey(), expressionInfo.getConvertor().convert(byArray2));
            string = string.replace(this.buildParameterKey(expressionInfo), expressionInfo.getReplacementKey());
            n += n2;
        }
        double d = JEPUtil.evaluate(string, hashMap);
        return Double.isNaN(d) || Double.isInfinite(d) ? 0.0 : d;
    }

    @Override
    public String getUnits() {
        return this.units;
    }

    @Override
    public GaugeMinMax getGaugeMinMax() {
        return this.gaugeMinMax;
    }

    @Override
    public String getFormat() {
        return this.format.toPattern();
    }

    @Override
    public String format(double d) {
        String string = this.format.format(d);
        if (this.replaceMap.containsKey(string)) {
            return this.replaceMap.get(string);
        }
        return string;
    }

    @Override
    public void setEcuDatas(EcuData[] ecuDataArray) {
        ParamChecker.checkNotNullOrEmpty(ecuDataArray, "ecuDatas");
        this.ecuDatas = ecuDataArray;
        for (EcuData ecuData : ecuDataArray) {
            this.addExpressionInfo(ecuData);
        }
    }

    public String toString() {
        return this.getUnits();
    }

    private void addExpressionInfo(EcuData ecuData) {
        String string = ecuData.getId();
        String string2 = '[' + string + ':';
        int n = this.expression.indexOf(string2);
        if (n >= 0) {
            EcuDataConvertor[] ecuDataConvertorArray;
            int n2 = n + string2.length();
            int n3 = this.expression.indexOf("]", n2);
            String string3 = this.expression.substring(n2, n3);
            EcuDataConvertor ecuDataConvertor = null;
            for (EcuDataConvertor ecuDataConvertor2 : ecuDataConvertorArray = ecuData.getConvertors()) {
                if (!string3.equals(ecuDataConvertor2.getUnits())) continue;
                ecuDataConvertor = ecuDataConvertor2;
            }
            this.expressionInfoMap.put(string, new ExpressionInfo(string, ecuDataConvertor, true));
        } else {
            this.expressionInfoMap.put(string, new ExpressionInfo(string, ecuData.getSelectedConvertor(), false));
        }
    }

    private String buildParameterKey(ExpressionInfo expressionInfo) {
        return '[' + expressionInfo.getEcuDataId() + ':' + expressionInfo.getConvertor().getUnits() + ']';
    }

    private static final class ExpressionInfo {
        private final String ecuDataId;
        private final EcuDataConvertor convertor;
        private final String replacementKey;

        public ExpressionInfo(String string, EcuDataConvertor ecuDataConvertor, boolean bl) {
            ParamChecker.checkNotNull(string, ecuDataConvertor);
            this.ecuDataId = string;
            this.convertor = ecuDataConvertor;
            this.replacementKey = bl ? this.buildCompositeKey(string, ecuDataConvertor.getUnits()) : string;
        }

        public String getEcuDataId() {
            return this.ecuDataId;
        }

        public String getReplacementKey() {
            return this.replacementKey;
        }

        public EcuDataConvertor getConvertor() {
            return this.convertor;
        }

        private String buildCompositeKey(String string, String string2) {
            if (string2 == null || string2.length() == 0) {
                return string;
            }
            return '_' + string + '_' + string2 + '_';
        }
    }
}

