/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.definition;

import com.romraider.logger.ecu.definition.EcuDataConvertor;
import com.romraider.logger.ecu.definition.xml.ConverterMaxMinDefaults;
import com.romraider.logger.ecu.ui.handler.dash.GaugeMinMax;
import com.romraider.util.ByteUtil;
import com.romraider.util.JEPUtil;
import com.romraider.util.ParamChecker;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EcuParameterConvertorImpl
implements EcuDataConvertor {
    private final String units;
    private final String expression;
    private final DecimalFormat format;
    private final int bit;
    private final boolean isFloat;
    private final Map<String, String> replaceMap;
    private final GaugeMinMax gaugeMinMax;

    public EcuParameterConvertorImpl() {
        this("Raw data", "x", "0", -1, false, new HashMap<String, String>(), ConverterMaxMinDefaults.getDefault());
    }

    public EcuParameterConvertorImpl(String string, String string2, String string3, int n, boolean bl, Map<String, String> map, GaugeMinMax gaugeMinMax) {
        ParamChecker.checkNotNullOrEmpty(string, "units");
        ParamChecker.checkNotNullOrEmpty(string2, "expression");
        ParamChecker.checkNotNullOrEmpty(string3, "format");
        ParamChecker.checkNotNull(map, "replaceMap");
        this.units = string;
        this.expression = string2;
        this.format = new DecimalFormat(string3);
        this.bit = n;
        this.isFloat = bl;
        this.replaceMap = map;
        this.gaugeMinMax = gaugeMinMax;
    }

    @Override
    public double convert(byte[] byArray) {
        if (ParamChecker.isValidBit(this.bit)) {
            return (byArray[0] & 1 << this.bit) > 0 ? 1.0 : 0.0;
        }
        double d = this.isFloat ? Float.intBitsToFloat(ByteUtil.asUnsignedInt(byArray)) : (float)ByteUtil.asUnsignedInt(byArray);
        double d2 = JEPUtil.evaluate(this.expression, d);
        return Double.isNaN(d2) || Double.isInfinite(d2) ? 0.0 : d2;
    }

    @Override
    public String getUnits() {
        return this.units;
    }

    @Override
    public GaugeMinMax getGaugeMinMax() {
        return this.gaugeMinMax;
    }

    @Override
    public String getFormat() {
        return this.format.toPattern();
    }

    @Override
    public String format(double d) {
        String string = this.format.format(d);
        if (this.replaceMap.containsKey(string)) {
            return this.replaceMap.get(string);
        }
        return string;
    }

    public String toString() {
        return this.getUnits();
    }
}

