/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.definition;

import com.romraider.logger.ecu.definition.EcuAddress;
import com.romraider.logger.ecu.definition.EcuDataConvertor;
import com.romraider.logger.ecu.definition.EcuDataType;
import com.romraider.logger.ecu.definition.EcuSwitch;
import com.romraider.util.ParamChecker;

public final class EcuSwitchImpl
implements EcuSwitch {
    private final String id;
    private final String name;
    private final String description;
    private final EcuAddress address;
    private final EcuDataConvertor[] convertors;
    private int selectedConvertorIndex;
    private boolean fileLogController;
    private boolean selected;

    public EcuSwitchImpl(String string, String string2, String string3, EcuAddress ecuAddress, EcuDataConvertor[] ecuDataConvertorArray) {
        ParamChecker.checkNotNullOrEmpty(string, "id");
        ParamChecker.checkNotNullOrEmpty(string2, "name");
        ParamChecker.checkNotNull((Object)string3, "description");
        ParamChecker.checkNotNull((Object)ecuAddress, "address");
        ParamChecker.checkNotNullOrEmpty(ecuDataConvertorArray, "convertors");
        this.id = string;
        this.name = string2;
        this.description = string3;
        this.address = ecuAddress;
        this.convertors = ecuDataConvertorArray;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public EcuAddress getAddress() {
        return this.address;
    }

    public EcuDataConvertor getSelectedConvertor() {
        return this.convertors[this.selectedConvertorIndex];
    }

    public EcuDataConvertor[] getConvertors() {
        return this.convertors;
    }

    public void selectConvertor(EcuDataConvertor ecuDataConvertor) {
        for (int i = 0; i < this.convertors.length; ++i) {
            EcuDataConvertor ecuDataConvertor2 = this.convertors[i];
            if (ecuDataConvertor != ecuDataConvertor2) continue;
            this.selectedConvertorIndex = i;
        }
    }

    public EcuDataType getDataType() {
        return EcuDataType.SWITCH;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public void setFileLogController(boolean bl) {
        this.fileLogController = bl;
    }

    public boolean isFileLogController() {
        return this.fileLogController;
    }
}

