/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.handler.dash;

import com.romraider.logger.ecu.definition.LoggerData;
import com.romraider.logger.ecu.ui.handler.dash.GaugeStyle;
import com.romraider.tts.Speaker;
import com.romraider.util.ParamChecker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class PlainGaugeStyle
implements GaugeStyle,
ActionListener {
    private static final String BLANK = "";
    private static final String ABOVE = "above";
    private static final String BELOW = "below";
    protected static final Color RED = new Color(190, 30, 30);
    protected static final Color GREEN = new Color(34, 139, 34);
    protected static final Color DARK_GREY = new Color(40, 40, 40);
    protected static final Color LIGHT_GREY = new Color(56, 56, 56);
    protected static final Color LIGHTER_GREY = new Color(120, 120, 120);
    protected final JPanel liveValuePanel = new JPanel(new BorderLayout());
    protected final JLabel liveValueLabel = new JLabel("", 0);
    protected final JLabel maxLabel = new JLabel("", 0);
    protected final JLabel minLabel = new JLabel("", 0);
    protected final JLabel title = new JLabel("", 0);
    protected final JProgressBar progressBar = new JProgressBar(1);
    protected final JCheckBox warnCheckBox = new JCheckBox("Warn");
    protected final JComboBox warnType = new JComboBox<Object>(new Object[]{"above", "below"});
    protected final JTextField warnTextField = new JTextField();
    private final String zeroText;
    private final LoggerData loggerData;
    private double max = Double.MIN_VALUE;
    private double min = Double.MAX_VALUE;
    private JPanel panel = new JPanel();

    public PlainGaugeStyle(LoggerData loggerData) {
        ParamChecker.checkNotNull((Object)loggerData, "loggerData");
        this.loggerData = loggerData;
        this.zeroText = this.format(loggerData, 0.0);
    }

    public void refreshTitle() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PlainGaugeStyle.this.title.setText(PlainGaugeStyle.this.loggerData.getName() + " (" + PlainGaugeStyle.this.loggerData.getSelectedConvertor().getUnits() + ')');
            }
        });
    }

    public void updateValue(double d) {
        this.refreshValue(d);
        if (this.warnCheckBox.isSelected() && this.isValidWarnThreshold()) {
            if (this.warnType.getSelectedItem() == ABOVE) {
                this.setWarning(d >= this.getWarnThreshold());
            } else if (this.warnType.getSelectedItem() == BELOW) {
                this.setWarning(d <= this.getWarnThreshold());
            }
        }
    }

    public void resetValue() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PlainGaugeStyle.this.liveValueLabel.setText(PlainGaugeStyle.this.zeroText);
                PlainGaugeStyle.this.max = Double.MIN_VALUE;
                PlainGaugeStyle.this.maxLabel.setText(PlainGaugeStyle.this.zeroText);
                PlainGaugeStyle.this.min = Double.MAX_VALUE;
                PlainGaugeStyle.this.minLabel.setText(PlainGaugeStyle.this.zeroText);
                PlainGaugeStyle.this.progressBar.setMinimum(PlainGaugeStyle.this.scaleForProgressBar(PlainGaugeStyle.this.min));
                PlainGaugeStyle.this.progressBar.setMaximum(PlainGaugeStyle.this.scaleForProgressBar(PlainGaugeStyle.this.max));
                PlainGaugeStyle.this.progressBar.setValue(PlainGaugeStyle.this.scaleForProgressBar(PlainGaugeStyle.this.min));
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.warnCheckBox && !this.warnCheckBox.isSelected()) {
            this.setWarning(false);
        }
    }

    public void apply(JPanel jPanel) {
        this.panel = jPanel;
        this.doApply(jPanel);
    }

    protected void doApply(JPanel jPanel) {
        this.refreshTitle();
        this.resetValue();
        jPanel.setPreferredSize(new Dimension(236, 144));
        jPanel.setBackground(LIGHT_GREY);
        jPanel.setLayout(new BorderLayout(3, 0));
        this.title.setFont(jPanel.getFont().deriveFont(1, 12.0f));
        this.title.setForeground(Color.WHITE);
        jPanel.add((Component)this.title, "North");
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 3, 1));
        jPanel2.setBackground(Color.BLACK);
        this.liveValueLabel.setFont(jPanel.getFont().deriveFont(0, 40.0f));
        this.liveValueLabel.setForeground(Color.WHITE);
        this.liveValuePanel.setBackground(LIGHT_GREY);
        this.liveValuePanel.setPreferredSize(new Dimension(140, 80));
        this.liveValuePanel.add((Component)this.liveValueLabel, "Center");
        jPanel2.add(this.liveValuePanel);
        JPanel jPanel3 = new JPanel(new BorderLayout(2, 2));
        jPanel3.setBackground(Color.BLACK);
        JPanel jPanel4 = this.buildMaxMinPanel("max", this.maxLabel);
        JPanel jPanel5 = this.buildMaxMinPanel("min", this.minLabel);
        jPanel3.add((Component)jPanel4, "North");
        jPanel3.add((Component)jPanel5, "South");
        jPanel2.add(jPanel3);
        this.progressBar.setStringPainted(false);
        this.progressBar.setIndeterminate(false);
        this.progressBar.setPreferredSize(new Dimension(20, 82));
        this.progressBar.setBackground(Color.WHITE);
        this.progressBar.setForeground(GREEN);
        jPanel2.add(this.progressBar);
        JPanel jPanel6 = new JPanel();
        jPanel6.setBackground(Color.BLACK);
        JPanel jPanel7 = new JPanel(new FlowLayout(1));
        jPanel7.setPreferredSize(new Dimension(226, 34));
        jPanel7.setBackground(Color.BLACK);
        jPanel7.setBorder(BorderFactory.createLineBorder(LIGHT_GREY, 1));
        this.warnCheckBox.setFont(jPanel.getFont().deriveFont(0, 10.0f));
        this.warnCheckBox.setBackground(Color.BLACK);
        this.warnCheckBox.setForeground(LIGHTER_GREY);
        this.warnCheckBox.setSelected(false);
        this.warnCheckBox.addActionListener(this);
        this.warnType.setPreferredSize(new Dimension(60, 20));
        this.warnType.setFont(jPanel.getFont().deriveFont(0, 10.0f));
        this.warnType.setBackground(Color.BLACK);
        this.warnType.setForeground(LIGHTER_GREY);
        this.warnTextField.setColumns(4);
        this.warnTextField.setBackground(Color.BLACK);
        this.warnTextField.setForeground(LIGHTER_GREY);
        this.warnTextField.setCaretColor(LIGHTER_GREY);
        jPanel7.add(this.warnCheckBox);
        jPanel7.add(this.warnType);
        jPanel7.add(this.warnTextField);
        jPanel6.add(jPanel7);
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel6, "South");
    }

    private JPanel buildMaxMinPanel(String string, JLabel jLabel) {
        JPanel jPanel = new JPanel(new BorderLayout(1, 1));
        jLabel.setFont(jPanel.getFont().deriveFont(0, 12.0f));
        jLabel.setForeground(Color.WHITE);
        jPanel.setPreferredSize(new Dimension(60, 38));
        jPanel.setBackground(LIGHT_GREY);
        JLabel jLabel2 = new JLabel(string, 0);
        jLabel2.setFont(jPanel.getFont().deriveFont(1, 12.0f));
        jLabel2.setForeground(Color.WHITE);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBackground(DARK_GREY);
        jPanel2.add((Component)jLabel, "Center");
        jPanel.add((Component)jLabel2, "North");
        jPanel.add((Component)jPanel2, "Center");
        return jPanel;
    }

    private void refreshValue(final double d) {
        final String string = this.format(this.loggerData, d);
        final int n = this.scaleForProgressBar(d);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (d > PlainGaugeStyle.this.max) {
                    PlainGaugeStyle.this.max = d;
                    PlainGaugeStyle.this.maxLabel.setText(string);
                    PlainGaugeStyle.this.progressBar.setMaximum(n);
                }
                if (d < PlainGaugeStyle.this.min) {
                    PlainGaugeStyle.this.min = d;
                    PlainGaugeStyle.this.minLabel.setText(string);
                    PlainGaugeStyle.this.progressBar.setMinimum(n);
                }
                PlainGaugeStyle.this.liveValueLabel.setText(string);
                PlainGaugeStyle.this.progressBar.setValue(n);
            }
        });
    }

    private boolean isValidWarnThreshold() {
        try {
            this.getWarnThreshold();
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private double getWarnThreshold() {
        return Double.parseDouble(this.warnTextField.getText());
    }

    private void setWarning(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (bl) {
                    PlainGaugeStyle.this.panel.setBackground(RED);
                    PlainGaugeStyle.this.liveValuePanel.setBackground(RED);
                    PlainGaugeStyle.this.progressBar.setForeground(RED);
                    Speaker.say("Warning!");
                } else {
                    PlainGaugeStyle.this.panel.setBackground(LIGHT_GREY);
                    PlainGaugeStyle.this.liveValuePanel.setBackground(LIGHT_GREY);
                    PlainGaugeStyle.this.progressBar.setForeground(GREEN);
                }
            }
        });
    }

    private String format(LoggerData loggerData, double d) {
        return loggerData.getSelectedConvertor().format(d);
    }

    private int scaleForProgressBar(double d) {
        return (int)(d * 1000.0);
    }
}

