/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.handler.livedata;

import com.romraider.logger.ecu.comms.query.Response;
import com.romraider.logger.ecu.definition.ConvertorUpdateListener;
import com.romraider.logger.ecu.definition.LoggerData;
import com.romraider.logger.ecu.ui.handler.DataUpdateHandler;
import com.romraider.logger.ecu.ui.handler.livedata.LiveDataTableModel;
import javax.swing.SwingUtilities;

public final class LiveDataUpdateHandler
implements DataUpdateHandler,
ConvertorUpdateListener {
    private final LiveDataTableModel dataTableModel;

    public LiveDataUpdateHandler(LiveDataTableModel liveDataTableModel) {
        this.dataTableModel = liveDataTableModel;
    }

    public synchronized void registerData(LoggerData loggerData) {
        this.dataTableModel.addParam(loggerData);
    }

    public synchronized void handleDataUpdate(final Response response) {
        for (final LoggerData loggerData : response.getData()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LiveDataUpdateHandler.this.dataTableModel.updateParam(loggerData, response.getDataValue(loggerData));
                }
            });
        }
    }

    public synchronized void deregisterData(LoggerData loggerData) {
        this.dataTableModel.removeParam(loggerData);
    }

    public synchronized void cleanUp() {
    }

    public synchronized void reset() {
        this.dataTableModel.reset();
    }

    public synchronized void notifyConvertorUpdate(LoggerData loggerData) {
        this.dataTableModel.resetRow(loggerData);
    }
}

