/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.swing.menubar.action;

import com.romraider.logger.ecu.EcuLogger;
import com.romraider.logger.ecu.ui.swing.menubar.action.AbstractAction;
import com.romraider.logger.ecu.ui.swing.menubar.util.FileHelper;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;

public final class LoadProfileAction
extends AbstractAction {
    public LoadProfileAction(EcuLogger ecuLogger) {
        super(ecuLogger);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.loadProfileDialog();
        }
        catch (Exception exception) {
            this.logger.reportError(exception);
        }
    }

    private void loadProfileDialog() throws Exception {
        File file = FileHelper.getFile(this.logger.getSettings().getLoggerProfileFilePath());
        JFileChooser jFileChooser = FileHelper.getProfileFileChooser(file);
        if (jFileChooser.showOpenDialog(this.logger) == 0) {
            String string = jFileChooser.getSelectedFile().getAbsolutePath();
            this.logger.loadUserProfile(string);
            this.logger.getSettings().setLoggerProfileFilePath(string);
            this.logger.reportMessageInTitleBar("Profile: " + string);
            this.logger.reportMessage("Profile succesfully loaded: " + string);
        }
    }
}

