/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.tab.injector;

import com.romraider.ECUEditor;
import com.romraider.logger.ecu.definition.EcuParameter;
import com.romraider.logger.ecu.definition.EcuSwitch;
import com.romraider.logger.ecu.definition.ExternalData;
import com.romraider.logger.ecu.ui.DataRegistrationBroker;
import com.romraider.logger.ecu.ui.tab.LoggerChartPanel;
import com.romraider.logger.ecu.ui.tab.injector.InjectorControlPanel;
import com.romraider.logger.ecu.ui.tab.injector.InjectorTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InjectorTabImpl
extends JPanel
implements InjectorTab {
    private static final long serialVersionUID = 5365322624406058883L;
    private final LoggerChartPanel chartPanel = new LoggerChartPanel("Pulse Width (ms)", "Fuel per Combustion Event (cc)");
    private final InjectorControlPanel controlPanel;

    public InjectorTabImpl(DataRegistrationBroker dataRegistrationBroker, ECUEditor eCUEditor) {
        super(new BorderLayout(2, 2));
        this.controlPanel = new InjectorControlPanel(this, dataRegistrationBroker, eCUEditor, this.chartPanel);
        JScrollPane jScrollPane = new JScrollPane(this.controlPanel, 22, 31);
        this.add((Component)jScrollPane, "West");
        this.add((Component)this.chartPanel, "Center");
    }

    @Override
    public double getFuelStoichAfr() {
        return this.controlPanel.getFuelStoichAfr();
    }

    @Override
    public double getFuelDensity() {
        return this.controlPanel.getFuelDensity();
    }

    @Override
    public boolean isRecordData() {
        return this.controlPanel.isRecordData();
    }

    @Override
    public boolean isValidClOl(double d) {
        return this.controlPanel.isValidClOl(d);
    }

    @Override
    public boolean isValidAfr(double d) {
        return this.controlPanel.isValidAfr(d);
    }

    @Override
    public boolean isValidRpm(double d) {
        return this.controlPanel.isValidRpm(d);
    }

    @Override
    public boolean isValidMaf(double d) {
        return this.controlPanel.isValidMaf(d);
    }

    @Override
    public boolean isValidCoolantTemp(double d) {
        return this.controlPanel.isValidCoolantTemp(d);
    }

    @Override
    public boolean isValidIntakeAirTemp(double d) {
        return this.controlPanel.isValidIntakeAirTemp(d);
    }

    @Override
    public boolean isValidMafvChange(double d) {
        return this.controlPanel.isValidMafvChange(d);
    }

    @Override
    public boolean isValidTipInThrottle(double d) {
        return this.controlPanel.isValidTipInThrottle(d);
    }

    @Override
    public void addData(double d, double d2) {
        this.chartPanel.addData(d, d2);
    }

    @Override
    public void setEcuParams(List<EcuParameter> list) {
        this.controlPanel.setEcuParams(list);
    }

    @Override
    public void setEcuSwitches(List<EcuSwitch> list) {
        this.controlPanel.setEcuSwitches(list);
    }

    @Override
    public void setExternalDatas(List<ExternalData> list) {
        this.controlPanel.setExternalDatas(list);
    }

    @Override
    public JPanel getPanel() {
        return this;
    }
}

