/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.maps;

import com.romraider.maps.Scale;
import com.romraider.maps.Table;
import com.romraider.util.JEPUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

public class DataCell
extends JLabel
implements MouseListener,
Serializable {
    private static final long serialVersionUID = -2904293227148940937L;
    private static final Logger LOGGER = Logger.getLogger(DataCell.class);
    private static final DecimalFormat PERCENT_FORMAT = new DecimalFormat("#,##0.0%");
    private final Border defaultBorder = BorderFactory.createLineBorder(Color.BLACK, 1);
    private final Border modifiedBorder = BorderFactory.createLineBorder(Color.RED, 3);
    private final Font defaultFont = new Font("Arial", 1, 12);
    private double binValue = 0.0;
    private double originalValue = 0.0;
    private Scale scale = new Scale();
    private String displayValue = "";
    private Color scaledColor = new Color(0, 0, 0);
    private Color highlightColor = new Color(155, 155, 255);
    private Color increaseBorder = Color.RED;
    private Color decreaseBorder = Color.BLUE;
    private Boolean selected = false;
    private Boolean highlighted = false;
    private Table table;
    private int x = 0;
    private int y = 0;
    private double compareValue = 0.0;
    private int compareType = 0;
    private int compareDisplay = 1;

    public DataCell() {
    }

    public DataCell(Scale scale, Dimension dimension) {
        this.scale = scale;
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
        this.setFont(this.defaultFont);
        this.setBorder(this.defaultBorder);
        this.setOpaque(true);
        this.setVisible(true);
        this.addMouseListener(this);
        this.setPreferredSize(dimension);
    }

    public void updateDisplayValue() {
        DecimalFormat decimalFormat = new DecimalFormat(this.scale.getFormat());
        if (this.getCompareType() == 0) {
            this.displayValue = this.getRealValue();
        } else if (this.getCompareDisplay() == 1) {
            this.displayValue = decimalFormat.format(this.calcDisplayValue(this.binValue, this.table.getScale().getExpression()) - this.calcDisplayValue(this.compareValue, this.table.getScale().getExpression()));
        } else if (this.getCompareDisplay() == 0) {
            double d;
            String string = this.table.getScale().getExpression();
            double d2 = this.calcDisplayValue(this.binValue, string);
            double d3 = d2 - (d = this.calcDisplayValue(this.compareValue, string));
            if (d3 == 0.0) {
                this.displayValue = PERCENT_FORMAT.format(0.0);
            } else if (d == 0.0) {
                this.displayValue = "\u221e%";
            } else {
                double d4 = d3 / Math.abs(d);
                this.displayValue = PERCENT_FORMAT.format(d4);
            }
        }
        this.setText(this.displayValue);
    }

    public double calcDisplayValue(double d, String string) {
        return JEPUtil.evaluate(string, d);
    }

    public void setColor(Color color) {
        this.scaledColor = color;
        if (!this.selected.booleanValue()) {
            super.setBackground(color);
        }
    }

    public void setDisplayValue(String string) {
        this.displayValue = string;
        this.setText(string);
    }

    public void setBinValue(double d) {
        this.binValue = d;
        if (this.table.getStorageType() != 99) {
            if (d < 0.0) {
                this.setBinValue(0.0);
            } else if (d > Math.pow(256.0, this.table.getStorageType()) - 1.0) {
                this.setBinValue((int)(Math.pow(256.0, this.table.getStorageType()) - 1.0));
            }
        }
        this.updateDisplayValue();
    }

    public double getBinValue() {
        return this.binValue;
    }

    public String toString() {
        return this.displayValue;
    }

    public Boolean isSelected() {
        return this.selected;
    }

    public void setSelected(Boolean bl) {
        this.selected = bl;
        if (bl.booleanValue()) {
            this.setBackground(this.getHighlightColor());
            this.table.getFrame().getToolBar().setFineValue(Math.abs(this.table.getScale().getFineIncrement()));
            this.table.getFrame().getToolBar().setCoarseValue(Math.abs(this.table.getScale().getCoarseIncrement()));
        } else {
            this.setBackground(this.scaledColor);
        }
    }

    public void setHighlighted(Boolean bl) {
        if (!this.table.isStatic()) {
            this.highlighted = bl;
            if (bl.booleanValue()) {
                this.setBackground(this.getHighlightColor());
            } else if (!this.selected.booleanValue()) {
                this.setBackground(this.scaledColor);
            }
        }
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.table.highlight(this.x, this.y);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.table.isStatic()) {
            if (!mouseEvent.isControlDown()) {
                this.table.clearSelection();
            }
            this.table.startHighlight(this.x, this.y);
        }
        this.requestFocus();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.table.isStatic()) {
            this.table.stopHighlight();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void increment(double d) {
        this.updateDisplayValue();
        double d2 = Double.parseDouble(this.getText());
        if (this.table.getScale().getCoarseIncrement() < 0.0) {
            d = 0.0 - d;
        }
        this.setRealValue(String.valueOf(this.calcDisplayValue(this.binValue, this.scale.getExpression()) + d));
        int n = (int)Math.pow(8.0, this.table.getStorageType());
        if (this.table.getStorageType() != 99 && d2 == Double.parseDouble(this.getText()) && this.binValue > 0.0 && this.binValue < (double)n) {
            LOGGER.debug((Object)(n + " " + this.binValue));
            this.increment(d * 2.0);
        }
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setXCoord(int n) {
        this.x = n;
    }

    public void setYCoord(int n) {
        this.y = n;
    }

    public double getOriginalValue() {
        return this.originalValue;
    }

    public void setOriginalValue(double d) {
        this.originalValue = d;
        if (this.binValue != this.getOriginalValue()) {
            this.setBorder(this.modifiedBorder);
        } else {
            this.setBorder(this.defaultBorder);
        }
    }

    public void undo() {
        this.setBinValue(this.originalValue);
    }

    public void setRevertPoint() {
        this.setOriginalValue(this.binValue);
    }

    public double getValue() {
        return this.calcDisplayValue(this.binValue, this.table.getScale().getExpression());
    }

    public String getRealValue() {
        return new DecimalFormat(this.scale.getFormat()).format(this.getValue());
    }

    public void setRealValue(String string) {
        if (!"x".equalsIgnoreCase(string)) {
            double d = JEPUtil.evaluate(this.table.getScale().getByteExpression(), Double.parseDouble(string));
            if (this.table.getStorageType() == 99) {
                this.setBinValue(d);
            } else {
                this.setBinValue((int)Math.round(d));
            }
        }
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color color) {
        this.highlightColor = color;
    }

    public Color getIncreaseBorder() {
        return this.increaseBorder;
    }

    public void setIncreaseBorder(Color color) {
        this.increaseBorder = color;
    }

    public Color getDecreaseBorder() {
        return this.decreaseBorder;
    }

    public void setDecreaseBorder(Color color) {
        this.decreaseBorder = color;
    }

    public double getCompareValue() {
        return this.compareValue;
    }

    public void setCompareValue(double d) {
        this.compareValue = d;
    }

    public int getCompareType() {
        return this.compareType;
    }

    public void setCompareType(int n) {
        this.compareType = n;
    }

    public int getCompareDisplay() {
        return this.compareDisplay;
    }

    public void setCompareRealValue(String string) {
        double d = JEPUtil.evaluate(this.table.getScale().getByteExpression(), Double.parseDouble(string));
        if (this.table.getStorageType() == 99) {
            this.setCompareValue(d);
        } else {
            this.setCompareValue((int)Math.round(d));
        }
    }

    public void setCompareDisplay(int n) {
        this.compareDisplay = n;
    }

    public void refreshValue() {
        this.setBinValue(this.binValue);
    }

    public void multiply(double d) {
        this.updateDisplayValue();
        this.setRealValue(String.valueOf(Double.parseDouble(this.getText()) * d));
    }

    public void setLiveDataTrace(boolean bl) {
        if (bl) {
            this.setForeground(Color.RED);
        } else {
            this.setForeground(Color.BLACK);
        }
    }
}

