/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.ramtune.test;

import com.romraider.Settings;
import com.romraider.io.protocol.Protocol;
import com.romraider.io.protocol.ssm.SSMProtocol;
import com.romraider.io.serial.port.SerialPortRefresher;
import com.romraider.logger.ecu.ui.SerialPortComboBox;
import com.romraider.ramtune.test.command.executor.CommandExecutorImpl;
import com.romraider.ramtune.test.command.generator.CommandGenerator;
import com.romraider.ramtune.test.command.generator.EcuInitCommandGenerator;
import com.romraider.ramtune.test.command.generator.ReadCommandGenerator;
import com.romraider.ramtune.test.command.generator.WriteCommandGenerator;
import com.romraider.ramtune.test.io.RamTuneTestAppConnectionProperties;
import com.romraider.swing.LookAndFeelManager;
import com.romraider.util.HexUtil;
import com.romraider.util.LogManager;
import com.romraider.util.ThreadUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public final class RamTuneTestApp
extends JFrame
implements WindowListener {
    private static final long serialVersionUID = 7140513114169019846L;
    private static final String REGEX_VALID_ADDRESS_BYTES = "[0-9a-fA-F]{6}";
    private static final String REGEX_VALID_DATA_BYTES = "[0-9a-fA-F]{2,}";
    private final Protocol protocol = new SSMProtocol();
    private final Settings settings = new Settings();
    private final JTextField addressField = new JTextField(6);
    private final JTextField lengthField = new JTextField(4);
    private final JTextField sendTimeoutField = new JTextField(4);
    private final JTextArea dataField = new JTextArea(10, 80);
    private final JTextArea responseField = new JTextArea(15, 80);
    private final SerialPortComboBox portsComboBox = new SerialPortComboBox(this.settings);
    private final JComboBox commandComboBox = new JComboBox<CommandGenerator>(new CommandGenerator[]{new EcuInitCommandGenerator(this.protocol), new ReadCommandGenerator(this.protocol), new WriteCommandGenerator(this.protocol)});

    public RamTuneTestApp(String string) {
        super(string);
        this.initUserInterface();
        this.startPortRefresherThread();
    }

    private void startPortRefresherThread() {
        SerialPortRefresher serialPortRefresher = new SerialPortRefresher(this.portsComboBox, this.settings.getLoggerPort());
        ThreadUtil.runAsDaemon(serialPortRefresher);
        while (!serialPortRefresher.isStarted()) {
            ThreadUtil.sleep(100L);
        }
    }

    private void initUserInterface() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = this.buildContentPanel();
        jPanel.add((Component)jPanel2, "Center");
        this.getContentPane().add(jPanel);
    }

    private JPanel buildContentPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.buildComPortPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add(this.buildInputPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add(this.buildOutputPanel(), gridBagConstraints);
        return jPanel;
    }

    private Component buildInputPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setBorder(new TitledBorder(new EtchedBorder(1), "Command"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.commandComboBox, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.add(new JLabel("Address (eg. 020000):"));
        jPanel2.add(this.addressField);
        JPanel jPanel3 = new JPanel(new FlowLayout());
        jPanel3.add(new JLabel("   Read Length:"));
        this.lengthField.setText("1");
        jPanel3.add(this.lengthField);
        jPanel3.add(new JLabel("byte(s)"));
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        this.dataField.setFont(new Font("Monospaced", 0, 12));
        this.dataField.setLineWrap(true);
        this.dataField.setBorder(new BevelBorder(1));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)new JScrollPane(this.dataField, 20, 31), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.buildSendButton(), gridBagConstraints);
        return jPanel;
    }

    private Component buildOutputPanel() {
        this.responseField.setFont(new Font("Monospaced", 0, 12));
        this.responseField.setLineWrap(true);
        this.responseField.setEditable(false);
        this.responseField.setBorder(new BevelBorder(1));
        JScrollPane jScrollPane = new JScrollPane(this.responseField, 20, 31);
        jScrollPane.setBorder(new TitledBorder(new EtchedBorder(1), "Trace"));
        return jScrollPane;
    }

    private JButton buildSendButton() {
        final JButton jButton = new JButton("Send Command");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ThreadUtil.runAsDaemon(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        jButton.setEnabled(false);
                        try {
                            RamTuneTestAppConnectionProperties ramTuneTestAppConnectionProperties = new RamTuneTestAppConnectionProperties(RamTuneTestApp.this.protocol.getDefaultConnectionProperties(), RamTuneTestApp.this.getSendTimeout());
                            CommandExecutorImpl commandExecutorImpl = new CommandExecutorImpl(ramTuneTestAppConnectionProperties, (String)RamTuneTestApp.this.portsComboBox.getSelectedItem());
                            CommandGenerator commandGenerator = (CommandGenerator)RamTuneTestApp.this.commandComboBox.getSelectedItem();
                            if (RamTuneTestApp.this.validateInput(commandGenerator) && RamTuneTestApp.this.confirmCommandExecution(commandGenerator)) {
                                StringBuilder stringBuilder = new StringBuilder();
                                List<byte[]> list = commandGenerator.createCommands(RamTuneTestApp.this.getData(), RamTuneTestApp.this.getAddress(), RamTuneTestApp.this.getLength());
                                for (byte[] byArray : list) {
                                    RamTuneTestApp.this.appendResponseLater("SND [" + commandGenerator + "]:\t" + HexUtil.asHex(byArray) + "\n");
                                    byte[] byArray2 = RamTuneTestApp.this.protocol.preprocessResponse(byArray, commandExecutorImpl.executeCommand(byArray));
                                    RamTuneTestApp.this.appendResponseLater("RCV [" + commandGenerator + "]:\t" + HexUtil.asHex(byArray2) + "\n");
                                    stringBuilder.append(HexUtil.asHex(RamTuneTestApp.this.protocol.parseResponseData(byArray2)));
                                }
                                RamTuneTestApp.this.appendResponseLater("DATA [Raw]:\t" + stringBuilder.toString() + "\n\n");
                            }
                        }
                        catch (Exception exception) {
                            RamTuneTestApp.this.reportError(exception);
                        }
                        finally {
                            jButton.setEnabled(true);
                        }
                    }
                });
            }
        });
        return jButton;
    }

    private void appendResponseLater(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RamTuneTestApp.this.responseField.append(string);
            }
        });
    }

    private byte[] getAddress() {
        try {
            return HexUtil.asBytes(this.addressField.getText());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private byte[] getData() {
        try {
            return HexUtil.asBytes(this.dataField.getText());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private int getLength() {
        return this.getIntFromField(this.lengthField);
    }

    private int getSendTimeout() {
        return this.getIntFromField(this.sendTimeoutField);
    }

    private int getIntFromField(JTextField jTextField) {
        try {
            return Integer.parseInt(jTextField.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private boolean validateInput(CommandGenerator commandGenerator) {
        String string;
        boolean bl = ReadCommandGenerator.class.isAssignableFrom(commandGenerator.getClass());
        boolean bl2 = WriteCommandGenerator.class.isAssignableFrom(commandGenerator.getClass());
        if (bl || bl2) {
            string = this.addressField.getText();
            if (string.trim().length() != 6) {
                this.showErrorDialog("Invalid address - must be 3 bytes long.");
                return false;
            }
            if (!string.matches(REGEX_VALID_ADDRESS_BYTES)) {
                this.showErrorDialog("Invalid address - bad bytes.");
                return false;
            }
        }
        if (bl) {
            try {
                int n = Integer.parseInt(this.lengthField.getText().trim());
                if (n <= 0) {
                    this.showErrorDialog("Invalid length - must be greater then zero.");
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.showErrorDialog("Invalid length.");
                return false;
            }
        }
        if (bl2) {
            string = this.dataField.getText().trim();
            int n = string.length();
            if (n == 0) {
                this.showErrorDialog("No data specified.");
                return false;
            }
            if (n % 2 != 0) {
                this.showErrorDialog("Invalid data - odd number of characters.");
                return false;
            }
            if (!string.matches(REGEX_VALID_DATA_BYTES)) {
                this.showErrorDialog("Invalid data - bad bytes.");
                return false;
            }
        }
        return true;
    }

    private boolean confirmCommandExecution(CommandGenerator commandGenerator) {
        boolean bl = WriteCommandGenerator.class.isAssignableFrom(commandGenerator.getClass());
        return !bl || JOptionPane.showConfirmDialog(this, "Are you sure you want to write to ECU memory?", "Confirm Write Command", 0, 2) == 0;
    }

    private JPanel buildComPortPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.buildComPorts());
        jPanel.add(this.buildSendTimeout());
        return jPanel;
    }

    private Component buildSendTimeout() {
        this.sendTimeoutField.setText("55");
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(new JLabel("Send Timeout:"));
        jPanel.add(this.sendTimeoutField);
        jPanel.add(new JLabel("ms"));
        return jPanel;
    }

    private JPanel buildComPorts() {
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(new JLabel("COM Port:"));
        jPanel.add(this.portsComboBox);
        return jPanel;
    }

    private void reportError(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        this.responseField.append("\n**************************************************************************\n");
        this.responseField.append("ERROR: ");
        this.responseField.append(((Object)stringWriter).toString());
        this.responseField.append("\n**************************************************************************\n\n");
    }

    private void showErrorDialog(String string) {
        JOptionPane.showMessageDialog(this, string, "Error", 0);
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public static void main(String[] stringArray) {
        LogManager.initDebugLogging();
        LookAndFeelManager.initLookAndFeel();
        RamTuneTestApp.startTestApp(3);
    }

    public static void startTestApp(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RamTuneTestApp ramTuneTestApp = new RamTuneTestApp("SSM Read/Write");
                ramTuneTestApp.setIconImage(new ImageIcon("./graphics/romraider-ico.gif").getImage());
                ramTuneTestApp.setDefaultCloseOperation(n);
                ramTuneTestApp.addWindowListener(ramTuneTestApp);
                ramTuneTestApp.setLocation(100, 50);
                ramTuneTestApp.pack();
                ramTuneTestApp.setVisible(true);
            }
        });
    }
}

