/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.ramtune.test.command.generator;

import com.romraider.io.protocol.Protocol;
import com.romraider.ramtune.test.command.generator.AbstractCommandGenerator;
import com.romraider.util.ParamChecker;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReadCommandGenerator
extends AbstractCommandGenerator {
    private static final int INCREMENT_SIZE = 32;

    public ReadCommandGenerator(Protocol protocol) {
        super(protocol);
    }

    @Override
    public List<byte[]> createCommands(byte[] byArray, byte[] byArray2, int n) {
        ParamChecker.checkNotNullOrEmpty(byArray2, "address");
        ParamChecker.checkGreaterThanZero(n, "length");
        if (n == 1) {
            return Arrays.asList(new byte[][]{this.createCommandForAddress(byArray2)});
        }
        return this.createCommandsForRange(byArray2, n);
    }

    private byte[] createCommandForAddress(byte[] byArray) {
        return this.protocol.constructReadAddressRequest(new byte[][]{byArray});
    }

    private List<byte[]> createCommandsForRange(byte[] byArray, int n) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        byte[] byArray2 = this.copy(byArray);
        for (int i = 0; i < n; i += 32) {
            int n2;
            int n3 = n2 = n - i > 32 ? 32 : n - i;
            if (n2 == 1) {
                arrayList.add(this.createCommandForAddress(byArray2));
            } else {
                arrayList.add(this.protocol.constructReadMemoryRequest(byArray2, n2));
            }
            System.arraycopy(this.incrementAddress(byArray2, n2), 0, byArray2, 0, byArray2.length);
        }
        return arrayList;
    }

    private byte[] copy(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return byArray2;
    }

    private byte[] incrementAddress(byte[] byArray, int n) {
        return new BigInteger(byArray).add(new BigInteger(String.valueOf(n))).toByteArray();
    }

    @Override
    public String toString() {
        return "Read";
    }
}

