/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.swing;

import com.romraider.ECUEditor;
import com.romraider.swing.XMLFilter;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.jdesktop.layout.GroupLayout;

public class DefinitionManager
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -3920843496218196737L;
    public static int MOVE_UP = 0;
    public static int MOVE_DOWN = 1;
    ECUEditor parent;
    Vector<String> fileNames;
    private JButton btnAddDefinition;
    private JButton btnApply;
    private JButton btnCancel;
    private JButton btnMoveDown;
    private JButton btnMoveUp;
    private JButton btnRemoveDefinition;
    private JButton btnSave;
    private JButton btnUndo;
    private JLabel defLabel;
    private JList definitionList;
    private JScrollPane jScrollPane1;

    public DefinitionManager(ECUEditor eCUEditor) {
        this.initComponents();
        this.parent = eCUEditor;
        this.initSettings();
        this.definitionList.setFont(new Font("Tahoma", 0, 11));
        this.definitionList.setSelectionMode(0);
        this.btnCancel.addActionListener(this);
        this.btnSave.addActionListener(this);
        this.btnAddDefinition.addActionListener(this);
        this.btnRemoveDefinition.addActionListener(this);
        this.btnMoveUp.addActionListener(this);
        this.btnMoveDown.addActionListener(this);
        this.btnApply.addActionListener(this);
        this.btnUndo.addActionListener(this);
    }

    private void initSettings() {
        Vector<File> vector = this.parent.getSettings().getEcuDefinitionFiles();
        this.fileNames = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            this.fileNames.add(vector.get(i).getAbsolutePath());
        }
        this.updateListModel();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.definitionList = new JList();
        this.defLabel = new JLabel();
        this.btnMoveUp = new JButton();
        this.btnMoveDown = new JButton();
        this.btnAddDefinition = new JButton();
        this.btnRemoveDefinition = new JButton();
        this.btnSave = new JButton();
        this.btnCancel = new JButton();
        this.btnApply = new JButton();
        this.btnUndo = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Definition File Manager");
        this.jScrollPane1.setViewportView(this.definitionList);
        this.defLabel.setText("ECU Definition File Priority");
        this.btnMoveUp.setText("Move Up");
        this.btnMoveDown.setText("Move Down");
        this.btnAddDefinition.setText("Add...");
        this.btnRemoveDefinition.setText("Remove");
        this.btnSave.setText("Save");
        this.btnCancel.setText("Cancel");
        this.btnApply.setText("Apply");
        this.btnUndo.setText("Undo");
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 448, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.btnSave).addPreferredGap(0).add((Component)this.btnApply).addPreferredGap(0).add((Component)this.btnUndo).addPreferredGap(0).add((Component)this.btnCancel)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.defLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.btnMoveDown).addPreferredGap(0).add((Component)this.btnMoveUp))).addPreferredGap(0, 80, Short.MAX_VALUE).add((Component)this.btnAddDefinition))).addPreferredGap(0).add((Component)this.btnRemoveDefinition))).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.btnAddDefinition, this.btnMoveDown, this.btnMoveUp, this.btnRemoveDefinition}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.defLabel).addPreferredGap(0).add((Component)this.jScrollPane1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.btnMoveUp).add((Component)this.btnMoveDown).add((Component)this.btnRemoveDefinition, -2, 23, -2).add((Component)this.btnAddDefinition)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.btnSave).add((Component)this.btnApply).add((Component)this.btnUndo).add((Component)this.btnCancel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnCancel) {
            this.dispose();
        } else if (actionEvent.getSource() == this.btnSave) {
            this.saveSettings();
            this.dispose();
        } else if (actionEvent.getSource() == this.btnApply) {
            this.saveSettings();
        } else if (actionEvent.getSource() == this.btnMoveUp) {
            this.moveSelection(MOVE_UP);
        } else if (actionEvent.getSource() == this.btnMoveDown) {
            this.moveSelection(MOVE_DOWN);
        } else if (actionEvent.getSource() == this.btnAddDefinition) {
            this.addFile();
        } else if (actionEvent.getSource() == this.btnRemoveDefinition) {
            this.removeSelection();
        } else if (actionEvent.getSource() == this.btnUndo) {
            this.initSettings();
        }
    }

    public void saveSettings() {
        Vector<File> vector = new Vector<File>();
        for (int i = 0; i < this.fileNames.size(); ++i) {
            vector.add(new File(this.fileNames.get(i)));
        }
        this.parent.getSettings().setEcuDefinitionFiles(vector);
    }

    public void addFile() {
        JFileChooser jFileChooser = new JFileChooser("./");
        jFileChooser.setFileFilter(new XMLFilter());
        if (jFileChooser.showOpenDialog(this) == 0) {
            this.fileNames.add(jFileChooser.getSelectedFile().getAbsolutePath());
            this.updateListModel();
        }
    }

    public void moveSelection(int n) {
        int n2 = this.definitionList.getSelectedIndex();
        String string = this.fileNames.get(n2);
        if (n == MOVE_UP && n2 > 0) {
            this.fileNames.remove(n2);
            this.fileNames.add(--n2, string);
        } else if (n == MOVE_DOWN && n2 < this.definitionList.getModel().getSize()) {
            this.fileNames.remove(n2);
            this.fileNames.add(++n2, string);
        }
        this.updateListModel();
        this.definitionList.setSelectedIndex(n2);
    }

    public void removeSelection() {
        int n = this.definitionList.getSelectedIndex();
        if (n < 0) {
            return;
        }
        this.fileNames.remove(n);
        this.updateListModel();
    }

    public void updateListModel() {
        this.definitionList.setListData(this.fileNames);
    }
}

