/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.util;

import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParamChecker {
    private ParamChecker() {
    }

    public static void checkNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException("Parameter " + string + " must not be null");
        }
    }

    public static void checkNotNull(Object ... objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            ParamChecker.checkNotNull(objectArray[i], "arg" + i);
        }
    }

    public static void checkNotNullOrEmpty(String string, String string2) {
        if (ParamChecker.isNullOrEmpty(string)) {
            throw new IllegalArgumentException("Parameter " + string2 + " must not be null or empty");
        }
    }

    public static void checkNotNullOrEmpty(Object[] objectArray, String string) {
        if (objectArray == null || objectArray.length == 0) {
            throw new IllegalArgumentException("Parameter " + string + " must not be null or empty");
        }
    }

    public static void checkNotNullOrEmpty(Collection<?> collection, String string) {
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException("Parameter " + string + " must not be null or empty");
        }
    }

    public static void checkNotNullOrEmpty(Map<?, ?> map, String string) {
        if (map == null || map.isEmpty()) {
            throw new IllegalArgumentException("Parameter " + string + " must not be null or empty");
        }
    }

    public static void checkGreaterThanZero(int n, String string) {
        if (n <= 0) {
            throw new IllegalArgumentException("Parameter " + string + " must be > 0");
        }
    }

    public static void checkNotNullOrEmpty(byte[] byArray, String string) {
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("Parameter " + string + " must not be null or empty");
        }
    }

    public static void checkBit(int n) {
        if (!ParamChecker.isValidBit(n)) {
            throw new IllegalArgumentException("Bit must be between 0 and 7 inclusive.");
        }
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNullOrEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isValidBit(int n) {
        return n >= 0 && n <= 7;
    }
}

