/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.xml;

import com.romraider.Settings;
import com.romraider.swing.JProgressPane;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.imageio.metadata.IIOMetadataNode;

public final class DOMSettingsBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildSettings(Settings settings, File file, JProgressPane jProgressPane, String string) throws IOException {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("settings");
        jProgressPane.update("Saving window settings...", 15);
        iIOMetadataNode.appendChild(this.buildWindow(settings));
        jProgressPane.update("Saving file settings...", 30);
        iIOMetadataNode.appendChild(this.buildFiles(settings));
        jProgressPane.update("Saving options...", 45);
        iIOMetadataNode.appendChild(this.buildOptions(settings, string));
        jProgressPane.update("Saving display settings...", 60);
        iIOMetadataNode.appendChild(this.buildTableDisplay(settings));
        jProgressPane.update("Saving logger settings...", 75);
        iIOMetadataNode.appendChild(this.buildLogger(settings));
        OutputFormat outputFormat = new OutputFormat("XML", "ISO-8859-1", true);
        outputFormat.setIndent(1);
        outputFormat.setIndenting(true);
        jProgressPane.update("Writing to file...", 90);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            XMLSerializer xMLSerializer = new XMLSerializer(fileOutputStream, outputFormat);
            xMLSerializer.serialize(iIOMetadataNode);
            fileOutputStream.flush();
        }
        finally {
            fileOutputStream.close();
        }
    }

    private IIOMetadataNode buildWindow(Settings settings) {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("window");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("maximized");
        iIOMetadataNode2.setAttribute("value", String.valueOf(settings.isWindowMaximized()));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("size");
        iIOMetadataNode3.setAttribute("x", String.valueOf((int)settings.getWindowSize().getHeight()));
        iIOMetadataNode3.setAttribute("y", String.valueOf((int)settings.getWindowSize().getWidth()));
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("location");
        iIOMetadataNode4.setAttribute("x", String.valueOf((int)settings.getWindowLocation().getX()));
        iIOMetadataNode4.setAttribute("y", String.valueOf((int)settings.getWindowLocation().getY()));
        iIOMetadataNode.appendChild(iIOMetadataNode4);
        IIOMetadataNode iIOMetadataNode5 = new IIOMetadataNode("splitpane");
        iIOMetadataNode5.setAttribute("location", String.valueOf(settings.getSplitPaneLocation()));
        iIOMetadataNode.appendChild(iIOMetadataNode5);
        return iIOMetadataNode;
    }

    private IIOMetadataNode buildFiles(Settings settings) {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("files");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("image_dir");
        iIOMetadataNode2.setAttribute("path", settings.getLastImageDir().getAbsolutePath());
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        Vector<File> vector = settings.getEcuDefinitionFiles();
        for (File file : vector) {
            IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("ecudefinitionfile");
            iIOMetadataNode3.setAttribute("name", file.getAbsolutePath());
            iIOMetadataNode.appendChild(iIOMetadataNode3);
        }
        return iIOMetadataNode;
    }

    private IIOMetadataNode buildOptions(Settings settings, String string) {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("options");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("obsoletewarning");
        iIOMetadataNode2.setAttribute("value", String.valueOf(settings.isObsoleteWarning()));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("calcconflictwarning");
        iIOMetadataNode3.setAttribute("value", String.valueOf(settings.isCalcConflictWarning()));
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("debug");
        iIOMetadataNode4.setAttribute("value", String.valueOf(settings.isDebug()));
        iIOMetadataNode.appendChild(iIOMetadataNode4);
        IIOMetadataNode iIOMetadataNode5 = new IIOMetadataNode("userlevel");
        iIOMetadataNode5.setAttribute("value", String.valueOf(settings.getUserLevel()));
        iIOMetadataNode.appendChild(iIOMetadataNode5);
        IIOMetadataNode iIOMetadataNode6 = new IIOMetadataNode("tableclickcount");
        iIOMetadataNode6.setAttribute("value", String.valueOf(settings.getTableClickCount()));
        iIOMetadataNode.appendChild(iIOMetadataNode6);
        IIOMetadataNode iIOMetadataNode7 = new IIOMetadataNode("version");
        iIOMetadataNode7.setAttribute("value", string);
        iIOMetadataNode.appendChild(iIOMetadataNode7);
        IIOMetadataNode iIOMetadataNode8 = new IIOMetadataNode("savedebugtables");
        iIOMetadataNode8.setAttribute("value", String.valueOf(settings.isSaveDebugTables()));
        iIOMetadataNode.appendChild(iIOMetadataNode8);
        IIOMetadataNode iIOMetadataNode9 = new IIOMetadataNode("displayhightables");
        iIOMetadataNode9.setAttribute("value", String.valueOf(settings.isDisplayHighTables()));
        iIOMetadataNode.appendChild(iIOMetadataNode9);
        IIOMetadataNode iIOMetadataNode10 = new IIOMetadataNode("valuelimitwarning");
        iIOMetadataNode10.setAttribute("value", String.valueOf(settings.isValueLimitWarning()));
        iIOMetadataNode.appendChild(iIOMetadataNode10);
        return iIOMetadataNode;
    }

    private IIOMetadataNode buildTableDisplay(Settings settings) {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("tabledisplay");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("font");
        iIOMetadataNode2.setAttribute("face", settings.getTableFont().getName());
        iIOMetadataNode2.setAttribute("size", String.valueOf(settings.getTableFont().getSize()));
        iIOMetadataNode2.setAttribute("decoration", String.valueOf(settings.getTableFont().getStyle()));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("cellsize");
        iIOMetadataNode3.setAttribute("height", String.valueOf((int)settings.getCellSize().getHeight()));
        iIOMetadataNode3.setAttribute("width", String.valueOf((int)settings.getCellSize().getWidth()));
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("colors");
        IIOMetadataNode iIOMetadataNode5 = new IIOMetadataNode("max");
        iIOMetadataNode5.setAttribute("r", String.valueOf(settings.getMaxColor().getRed()));
        iIOMetadataNode5.setAttribute("g", String.valueOf(settings.getMaxColor().getGreen()));
        iIOMetadataNode5.setAttribute("b", String.valueOf(settings.getMaxColor().getBlue()));
        iIOMetadataNode4.appendChild(iIOMetadataNode5);
        IIOMetadataNode iIOMetadataNode6 = new IIOMetadataNode("min");
        iIOMetadataNode6.setAttribute("r", String.valueOf(settings.getMinColor().getRed()));
        iIOMetadataNode6.setAttribute("g", String.valueOf(settings.getMinColor().getGreen()));
        iIOMetadataNode6.setAttribute("b", String.valueOf(settings.getMinColor().getBlue()));
        iIOMetadataNode4.appendChild(iIOMetadataNode6);
        IIOMetadataNode iIOMetadataNode7 = new IIOMetadataNode("highlight");
        iIOMetadataNode7.setAttribute("r", String.valueOf(settings.getHighlightColor().getRed()));
        iIOMetadataNode7.setAttribute("g", String.valueOf(settings.getHighlightColor().getGreen()));
        iIOMetadataNode7.setAttribute("b", String.valueOf(settings.getHighlightColor().getBlue()));
        iIOMetadataNode4.appendChild(iIOMetadataNode7);
        IIOMetadataNode iIOMetadataNode8 = new IIOMetadataNode("increaseborder");
        iIOMetadataNode8.setAttribute("r", String.valueOf(settings.getIncreaseBorder().getRed()));
        iIOMetadataNode8.setAttribute("g", String.valueOf(settings.getIncreaseBorder().getGreen()));
        iIOMetadataNode8.setAttribute("b", String.valueOf(settings.getIncreaseBorder().getBlue()));
        iIOMetadataNode4.appendChild(iIOMetadataNode8);
        IIOMetadataNode iIOMetadataNode9 = new IIOMetadataNode("decreaseborder");
        iIOMetadataNode9.setAttribute("r", String.valueOf(settings.getDecreaseBorder().getRed()));
        iIOMetadataNode9.setAttribute("g", String.valueOf(settings.getDecreaseBorder().getGreen()));
        iIOMetadataNode9.setAttribute("b", String.valueOf(settings.getDecreaseBorder().getBlue()));
        iIOMetadataNode4.appendChild(iIOMetadataNode9);
        IIOMetadataNode iIOMetadataNode10 = new IIOMetadataNode("axis");
        iIOMetadataNode10.setAttribute("r", String.valueOf(settings.getAxisColor().getRed()));
        iIOMetadataNode10.setAttribute("g", String.valueOf(settings.getAxisColor().getGreen()));
        iIOMetadataNode10.setAttribute("b", String.valueOf(settings.getAxisColor().getBlue()));
        iIOMetadataNode4.appendChild(iIOMetadataNode10);
        IIOMetadataNode iIOMetadataNode11 = new IIOMetadataNode("warning");
        iIOMetadataNode11.setAttribute("r", String.valueOf(settings.getWarningColor().getRed()));
        iIOMetadataNode11.setAttribute("g", String.valueOf(settings.getWarningColor().getGreen()));
        iIOMetadataNode11.setAttribute("b", String.valueOf(settings.getWarningColor().getBlue()));
        iIOMetadataNode4.appendChild(iIOMetadataNode11);
        iIOMetadataNode.appendChild(iIOMetadataNode4);
        return iIOMetadataNode;
    }

    private IIOMetadataNode buildLogger(Settings settings) {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("logger");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("serial");
        iIOMetadataNode2.setAttribute("port", settings.getLoggerPortDefault());
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("maximized");
        iIOMetadataNode3.setAttribute("value", String.valueOf(settings.isLoggerWindowMaximized()));
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("size");
        iIOMetadataNode4.setAttribute("x", String.valueOf((int)settings.getLoggerWindowSize().getHeight()));
        iIOMetadataNode4.setAttribute("y", String.valueOf((int)settings.getLoggerWindowSize().getWidth()));
        iIOMetadataNode.appendChild(iIOMetadataNode4);
        IIOMetadataNode iIOMetadataNode5 = new IIOMetadataNode("location");
        iIOMetadataNode5.setAttribute("x", String.valueOf((int)settings.getLoggerWindowLocation().getX()));
        iIOMetadataNode5.setAttribute("y", String.valueOf((int)settings.getLoggerWindowLocation().getY()));
        iIOMetadataNode.appendChild(iIOMetadataNode5);
        IIOMetadataNode iIOMetadataNode6 = new IIOMetadataNode("tabs");
        iIOMetadataNode6.setAttribute("selected", String.valueOf(settings.getLoggerSelectedTabIndex()));
        iIOMetadataNode.appendChild(iIOMetadataNode6);
        IIOMetadataNode iIOMetadataNode7 = new IIOMetadataNode("definition");
        iIOMetadataNode7.setAttribute("path", settings.getLoggerDefinitionFilePath());
        iIOMetadataNode.appendChild(iIOMetadataNode7);
        IIOMetadataNode iIOMetadataNode8 = new IIOMetadataNode("profile");
        iIOMetadataNode8.setAttribute("path", settings.getLoggerProfileFilePath());
        iIOMetadataNode.appendChild(iIOMetadataNode8);
        IIOMetadataNode iIOMetadataNode9 = new IIOMetadataNode("filelogging");
        iIOMetadataNode9.setAttribute("path", settings.getLoggerOutputDirPath());
        iIOMetadataNode9.setAttribute("switchid", settings.getFileLoggingControllerSwitchId());
        iIOMetadataNode9.setAttribute("active", String.valueOf(settings.isFileLoggingControllerSwitchActive()));
        iIOMetadataNode9.setAttribute("absolutetimestamp", String.valueOf(settings.isFileLoggingAbsoluteTimestamp()));
        iIOMetadataNode.appendChild(iIOMetadataNode9);
        return iIOMetadataNode;
    }
}

