##############################################################################
#    pvm
#    software development environment
#
#    Copyright (C) 1997  Andrew Guryanov
#    andrew-guryanov@usa.net
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
##############################################################################

#===========================================
#	Global variables
#===========================================
global standard_program_disclaimer
set standard_program_disclaimer \
"\n\
This program is free software; you can redistribute it and/or modify\n\
it under the terms of the GNU General Public License as published by\n\
the Free Software Foundation; either version 2 of the License, or\n\
(at your option) any later version.\n\
\n\
This program is distributed in the hope that it will be useful,\n\
but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n\
GNU General Public License for more details.\n\
"

global dlgdata
set dlgdata(count) 0

#===========================================
#	DialogBox event handlers
#===========================================

proc dialog:OnOK {this} {
#------------------------------
    dialog:EndDialog $this ok
}

proc dialog:OnCancel {this} {
#------------------------------
    dialog:EndDialog $this cancel
}

proc dialog:OnApply {this} {
#------------------------------
    puts "dialog:OnApply makes nothing"
}

#===========================================
#	DialogBox methods
#===========================================

proc dialog:EndDialog {dlgwindow retcode} {
#---------------------------------------
    global dlgdata
    set id [main:GetWindowId $dlgwindow]
    if {$dlgdata($id,modal)} {
        set dlgdata($id,return) $retcode
    } else {
        main:DlgDispatch OnDestroyModeless $dlgwindow
    }
}

proc dialog:BindDefaultEvents {this} {
#---------------------------------------
    bind $this <Return> { main:DlgDispatch OnOK}
    bind $this <Escape> { main:DlgDispatch OnCancel}
}

proc dialog:CenterDialog {this} {
#-----------------------------------
    set size [wm minsize $this]
    set width  [lindex $size 0]
    set height [lindex $size 1]
#    set width  [winfo reqwidth  ${this}]
#    set height [winfo reqheight ${this}]
    set parent [winfo parent ${this}]
    set x [expr [winfo rootx ${parent}] + ([winfo width  ${parent}] - $width)/2]
    set y [expr [winfo rooty ${parent}] + ([winfo height ${parent}] - $height)/2]
    wm geometry ${this} +${x}+${y}
}

proc dialog:DoModal {this} {
#----------------------------------
    global dlgdata

    set id [main:GetWindowId $this]
    set dlgdata($id,return) ""
    set dlgdata($id,modal) 1

    set oldFocus [focus]
    set oldGrab [grab current $this]
    if {$oldGrab != ""} {
	    set grabStatus [grab status $oldGrab]
    }
    grab $this
    set prevcursor [$this cget -cursor]
    $this configure -cursor watch
    main:DlgDispatch OnInitDialog $this
    $this configure -cursor $prevcursor
    tkwait variable dlgdata($id,return)
    grab release $this
    if {$oldGrab != ""} {
        if {$grabStatus == "global"} {
            grab -global $oldGrab
        } else {
            grab $oldGrab
        }
    }
    destroy $this
    if {[winfo exists $oldFocus]} {
        focus $oldFocus
    }
    set ret $dlgdata($id,return)
    foreach name [array names dlgdata "$id,*"] {
        unset dlgdata($name)
    }
    return $ret
}

proc dialog:OnDestroyModeless {this} {
#--------------------------------------
    global dlgdata
    set id [main:GetWindowId $this]
    destroy $this
    foreach name [array names dlgdata "$id,*"] {
        unset dlgdata($name)
    }
}

proc dialog:PreCreateDialog {parent dlgtype} {
#-----------------------------------------------------
    global dlgdata
    incr dlgdata(count)
    set this $parent.$dlgtype-$dlgdata(count)
    toplevel $this -class Dialog
    set id [main:GetWindowId $this]
    set dlgdata($id,modal) 0
    wm geometry $this 400x200+200+200
    wm maxsize $this 1265 994
    wm minsize $this 1 1
    wm focusmodel $this passive
    wm overrideredirect $this 0
    wm resizable $this 1 1
    wm deiconify $this
    wm protocol $this WM_DELETE_WINDOW { }
    return $this
}

proc dialog:PostCreateDialog {this dlgmode args} {
#-----------------------------------------------------
    set arglist $args
    set arglist [string trimleft $arglist "{"]
    set arglist [string trimright $arglist "}"]
    set btnlist [split $arglist]
    switch $dlgmode {
        vert { set btnpack "bottom"}
        hor  { set btnpack "right"}
        tab  { set btnpack "right"}
        default { set btnpack "bottom"}
    }

    foreach btn $btnlist {
        set btnname [string tolower $btn]
        switch $btnname {
            ok      { set cmnd "main:DlgDispatch OnOK"}
            cancel  { set cmnd "main:DlgDispatch OnCancel"}
            apply   { set cmnd "main:DlgDispatch OnApply"}
            yes     { set cmnd "main:DlgDispatch EndDialog $this yes"}
            no      { set cmnd "main:DlgDispatch EndDialog $this no"}
            default { set cmnd ""}
        }
        regsub -all "_" $btn " " btntext
        button $this.choice.$btnname -padx 9 -pady 3 -text "$btntext" -width 10 -command $cmnd
        pack $this.choice.$btnname -anchor center -expand 0 -fill none -padx 10 -pady 10 -side $btnpack
    }
    dialog:BindDefaultEvents $this
}

proc dialog:CreateVertDialog {parent dlgtype args} {
#-----------------------------------------------------
    set this [dialog:PreCreateDialog $parent $dlgtype]

    frame $this.info   -borderwidth 1 -height 30 -relief flat -width 30 
    frame $this.choice -borderwidth 1 -height 30 -relief flat -width 30 
    pack $this.info   -anchor center -expand 1 -fill both -side left 
    pack $this.choice -anchor center -expand 0 -fill y -side right 

    dialog:PostCreateDialog $this vert $args
    return $this
}

proc dialog:CreateHorDialog {parent dlgtype args} {
#-----------------------------------------------------
    set this [dialog:PreCreateDialog $parent $dlgtype]

    frame $this.info   -borderwidth 1 -height 30 -relief flat -width 30 
    frame $this.choice -borderwidth 1 -height 30 -relief flat -width 30 
    pack $this.info   -anchor center -expand 1 -fill both -side top
    pack $this.choice -anchor center -expand 0 -fill x -side bottom

    dialog:PostCreateDialog $this hor $args
    return $this
}

proc dialog:GetDialogFrame {this frame} {
#-----------------------------------------------------
    return $this.$frame
}

proc dialog:CreateTabDialog {parent dlgtype args} {
#-----------------------------------------------------
    global dlgdata
    set this [dialog:PreCreateDialog $parent $dlgtype]
    set id [main:GetWindowId $this]
    set dlgdata($id,active_tab_page) ""

    frame $this.section -borderwidth 1 -height 30 -relief flat -width 30 
    frame $this.info    -borderwidth 1 -height 30 -relief flat -width 30 
    frame $this.choice  -borderwidth 1 -height 30 -relief flat -width 30 
    pack $this.section  -anchor center -expand 0 -fill x -side top 
    pack $this.info     -anchor center -expand 1 -fill both -side top 
    pack $this.choice   -anchor center -expand 0 -fill x -side bottom 

    dialog:PostCreateDialog $this tab $args
    return $this
}

proc dialog:CreateTabPage {this pagename} {
#-------------------------------------------------
    set fr_name [string tolower $pagename]
    regsub -all "_" $pagename " " pagetext
    button $this.section.$fr_name -padx 9 -pady 3 -text "$pagetext" -width 1 \
        -command "main:DlgDispatch ActivateTabPage $this $pagename"
    pack $this.section.$fr_name -anchor center -expand 1 -fill x -padx 0 -pady 10 -side left
    frame $this.info.$fr_name -borderwidth 1 -height 30 -relief sunken -width 30
    place $this.info.$fr_name -x 5 -y 5 -width 30 -height 30 -anchor nw -bordermode ignore 
    return  $this.info.$fr_name
}

proc dialog:GetTabPage {this pagename} {
#-------------------------------------------------
    set fr_name [string tolower $pagename]
    return $this.info.$fr_name
}

proc dialog:ActivateTabPage {this pagename} {
#-------------------------------------------------
    global dlgdata
    set id [main:GetWindowId $this]
    set fr_new [string tolower $pagename]
    set fr_old $dlgdata($id,active_tab_page)
    if {[string compare $fr_new $fr_old] && [winfo exists $this.info.$fr_new]} {
        if {[winfo exists $this.info.$fr_old]} {
            $this.section.$fr_old configure -relief raised
            pack forget $this.info.$fr_old
            place $this.info.$fr_old -x 0 -y 0 -width 30 -height 30
        }
        $this.section.$fr_new configure -relief sunken
        place forget $this.info.$fr_new
        pack $this.info.$fr_new -expand 1 -fill both -anchor n -side top
        raise $this.info.$fr_new
        set dlgdata($id,active_tab_page) $fr_new
    }
}

proc dialog-about:CreateDialog {parent} {
#-------------------------------------------------
    global main
	global standard_program_disclaimer
    set this [dialog:CreateVertDialog $parent "dialog-about" Ok More]
    if {![winfo exists $this]} {
        return ""
    }
    wm geometry $this 600x200+335+249
    wm minsize $this 450 200
    wm title $this "About"

    set page [dialog:GetDialogFrame $this info]

    frame $page.f1 -borderwidth 1 -height 1 -relief flat -width 10
    label $page.f1.l1  -relief flat -text "$main(app,title), version $main(app,version)"
    label $page.f1.l2  -relief flat -text {C/C++/etc software development environment} 
    label $page.f1.l3  -relief flat -text {Copyright (C) 1997  Andrew Guryanov} 
    pack  $page.f1.l1  -anchor center -expand 0 -fill x -pady 2 -side top 
    pack  $page.f1.l2 -anchor center -expand 0 -fill x -pady 2 -side top 
    pack  $page.f1.l3 -anchor center -expand 0 -fill x -pady 2 -side top 
    
    frame $page.f2 -borderwidth 1 -height 1 -relief ridge -width 1 -height 1
    text $page.f2.text -relief flat -wrap none -width 10 -font fixed -xscrollcommand "$page.f2.xscroll set" -yscrollcommand "$page.f2.yscroll set"
    scrollbar $page.f2.yscroll -command "$page.f2.text yview" -orient vertical -relief ridge
    scrollbar $page.f2.xscroll -command "$page.f2.text xview" -orient horizontal -relief ridge
    $page.f2.text insert end $standard_program_disclaimer

    $page.f2.text config -state disabled
    pack $page.f2.yscroll -side right -fill y
    pack $page.f2.xscroll -side bottom -fill x
    pack $page.f2.text -expand 1 -fill both -side bottom

    pack $page.f1 -anchor center -expand 1 -fill x -side top
    pack $page.f2 -anchor center -expand 1 -fill both -side bottom -padx 4 -pady 4

    set page [dialog:GetDialogFrame $this choice]
    label $page.icon -bitmap @$main(app,icon)
    pack $page.icon -anchor center -expand 1 -fill none -side top
    $page.more configure  -command {main:DlgDispatch OnShowText} -text "More..."

    dialog:CenterDialog $this
    return $this
}

proc dialog-about:OnShowText {this} {
#-------------------------------------------------
    set dlg [dialog-moreabout:CreateDialog $this]
    main:DlgDispatch DoModal $dlg
}

proc dialog-moreabout:CreateDialog {parent} {
#-------------------------------------------------
    set this [dialog:CreateTabDialog $parent "dialog-moreabout" Ok]
    if {![winfo exists $this]} {
        return ""
    }
    wm geometry $this 600x400+300+200
    wm minsize $this 400 200
    wm title $this "More about"
    dialog-moreabout:CreateTextPage $this Register
    dialog-moreabout:CreateTextPage $this Read_Me
    dialog-moreabout:CreateTextPage $this License
    dialog-moreabout:CreateTextPage $this Changes
    dialog:ActivateTabPage $this Register
    dialog:CenterDialog $this
    return $this
}

proc dialog-moreabout:CreateTextPage {this name} {
#------------------------------------------------
    set page [dialog:CreateTabPage $this $name]
    text $page.text -relief flat -wrap none -width 1 -height 1 \
        -xscrollcommand "$page.xscroll set" -yscrollcommand "$page.yscroll set"
    scrollbar $page.yscroll -command "$page.text yview" -orient vertical -relief ridge
    scrollbar $page.xscroll -command "$page.text xview" -orient horizontal -relief ridge
    pack $page.yscroll -side right -fill y
    pack $page.xscroll -side bottom -fill x
    pack $page.text -expand 1 -fill both -side bottom
}

proc dialog-moreabout:LoadFile {dest filename} {
#-------------------------------------------
    if {[file isfile $filename]} {
        set f [open $filename "r"]
        if {$f != ""} {
            while {![eof $f]} {
                $dest insert end [read $f 1000]
            }
            close $f
        } else {
            $dest insert end "failed to read file $filename"
        }
    } else {
        $dest insert end "file $filename not found"
    }
    $dest mark set insert 1.0
    $dest see insert
    $dest config -state disabled -font [main:GetMainData font def]
}

proc dialog-moreabout:OnInitDialog {this} {
#----------------------------------------
    global main
    set page [dialog:GetTabPage $this Register]
    dialog-moreabout:LoadFile $page.text $main(app,home)/REGISTER.txt
    set page [dialog:GetTabPage $this Read_Me]
    dialog-moreabout:LoadFile $page.text $main(app,home)/README.txt
    set page [dialog:GetTabPage $this License]
    dialog-moreabout:LoadFile $page.text $main(app,home)/LICENSE.txt
    set page [dialog:GetTabPage $this Changes]
    dialog-moreabout:LoadFile $page.text $main(app,home)/CHANGES.txt
}

proc dialog:MessageBox {parent title msg btnlist} {
#-------------------------------------------------
    set lst [split $btnlist "-"]
    if {[llength $lst] > 2} {
        set this [dialog:CreateHorDialog $parent "dialog" $lst]
    } else {
        set this [dialog:CreateVertDialog $parent "dialog" $lst]
    }
    if {![winfo exists $this]} {
        return ""
    }
    wm geometry $this 350x150+335+249
    wm minsize $this 350 150
    wm title $this $title

    set page [dialog:GetDialogFrame $this info]
    message $page.msg -aspect 500 -justify center -padx 5 -pady 2 -text $msg
    pack  $page.msg  -anchor center -expand 1 -fill both -side top 

    dialog:CenterDialog $this
    set ret [main:DlgDispatch DoModal $this]
    return $ret
}

proc dialog-find:CreateDialog {parent} {
#-------------------------------------------------
    set this [dialog:CreateHorDialog $parent "dialog-find" Close Find Replace Replace_All]
    if {![winfo exists $this]} {
        return ""
    }
    wm geometry $this 500x150+335+249
    wm minsize $this 500 150
    wm title $this "Find"
    global dlgdata
    set id [main:GetWindowId $this]

    set page [dialog:GetDialogFrame $this info]
    frame  $page.f0 -borderwidth 1 -height 1 -relief flat -width 30 
    label  $page.f0.l -anchor w -relief flat -width 20 -text {Find what}
    entry  $page.f0.ent -relief ridge -font [main:GetMainData font def]
    frame  $page.f1 -borderwidth 1 -height 1 -relief flat -width 30 
    label  $page.f1.l -anchor w -relief flat -width 20 -text {Replace with}
    entry  $page.f1.ent -relief ridge -font [main:GetMainData font def]
    frame  $page.f2 -borderwidth 1 -height 1 -relief flat -width 30 
    checkbutton  $page.f2.case -anchor w -relief flat -width 15 -text {Case Sensitive} -variable dlgdata($id,case)
    checkbutton  $page.f2.mode -anchor w -relief flat -width 10 -text {Regexp} -variable dlgdata($id,regexp)
    radiobutton  $page.f2.next -anchor w -relief flat -width 10 -text {Next} -variable dlgdata($id,direction) -value "next"
    radiobutton  $page.f2.prev -anchor w -relief flat -width 10 -text {Previous} -variable dlgdata($id,direction) -value "prev"
    pack $page.f0 -anchor center -expand 1 -fill x -side top 
    pack $page.f0.l -anchor center -expand 0 -fill none -padx 5 -side left 
    pack $page.f0.ent  -anchor center -expand 1 -fill x -side right 
    pack $page.f1 -anchor center -expand 1 -fill x -side top 
    pack $page.f1.l -anchor center -expand 0 -fill none -padx 5 -side left 
    pack $page.f1.ent  -anchor center -expand 1 -fill x -side right 
    pack $page.f2 -anchor center -expand 1 -fill x -side top 
    pack $page.f2.case -anchor center -expand 1 -fill none -padx 5 -side left 
    pack $page.f2.mode -anchor center -expand 1 -fill none -padx 5 -side left 
    pack $page.f2.prev -anchor center -expand 1 -fill none -padx 5 -side right
    pack $page.f2.next -anchor center -expand 1 -fill none -padx 5 -side right
    $page.f2.next select

    set page [dialog:GetDialogFrame $this choice]
    $page.close configure  -command "main:DlgDispatch OnDestroyModeless"
    $page.find configure  -command "main:DlgDispatch OnFind"
    $page.replace configure  -command "main:DlgDispatch OnReplace"
    $page.replace_all configure  -command "main:DlgDispatch OnReplaceAll"

    dialog:CenterDialog $this
    return $this
}

proc dialog-find:OnFind {this} {
#--------------------------------------
    global dlgdata
    set id [main:GetWindowId $this]
    set page [dialog:GetDialogFrame $this info]
    set find [$page.f0.ent get]
    if {$find != ""} {
        set res [main:DocDispatch OnFindText "" "$find" $dlgdata($id,direction) $dlgdata($id,case) 0 $dlgdata($id,regexp)]
        if {$res == ""} {set res 0}
        if {!$res} {
            bell
        }
    }
}

proc dialog-find:OnReplace {this} {
#--------------------------------------
    set page [dialog:GetDialogFrame $this info]
    set replace [$page.f1.ent get]
    main:DocDispatch OnReplaceText "" $replace
}

proc dialog-find:OnReplaceAll {this} {
#--------------------------------------
    global dlgdata
    set id [main:GetWindowId $this]
    set page [dialog:GetDialogFrame $this info]
    set find [$page.f0.ent get]
    set replace [$page.f1.ent get]
    if {$find != ""} {
        while {1} {
            set res [main:DocDispatch OnFindText "" "$find" $dlgdata($id,direction) $dlgdata($id,case) 0 $dlgdata($id,regexp)]
            if {$res == ""} {set res 0}
            if {$res} {
                main:DocDispatch OnReplaceText "" $replace
            } else {
                bell
                break
            }
        }
    }
}

proc dialog-find:OnOK {this} {
#--------------------------------------
    dialog-find:OnFind $this
}

proc dialog-tool:CreateDialog {parent} {
#-------------------------------------------------
    set this [dialog:CreateHorDialog $parent "dialog-tool" Close Run]
    if {![winfo exists $this]} {
        return ""
    }
    wm geometry $this 500x150+335+249
    wm minsize $this 500 150
    wm title $this "Execute external program"
    global dlgdata
    set id [main:GetWindowId $this]

    set dlgdata($id,clear) 1
    set page [dialog:GetDialogFrame $this info]
    frame  $page.f0 -borderwidth 1 -height 1 -relief flat -width 30 
    label  $page.f0.l -anchor w -relief flat -width 20 -text {Command}
    entry  $page.f0.ent -relief ridge -font [main:GetMainData font def]
    frame  $page.f1 -borderwidth 1 -height 1 -relief flat -width 30 
    label  $page.f1.l -anchor w -relief flat -width 20 -text {Start-up dir}
    entry  $page.f1.ent -relief ridge -font [main:GetMainData font def]
    frame  $page.f2 -borderwidth 1 -height 1 -relief flat -width 30 
    checkbutton  $page.f2.clear -anchor w -relief flat -width 20 -text {Clear output window} -variable dlgdata($id,clear)
    pack $page.f0 -anchor center -expand 1 -fill x -side top 
    pack $page.f0.l -anchor center -expand 0 -fill none -padx 5 -side left 
    pack $page.f0.ent  -anchor center -expand 1 -fill x -side right 
    pack $page.f1 -anchor center -expand 1 -fill x -side top 
    pack $page.f1.l -anchor center -expand 0 -fill none -padx 5 -side left 
    pack $page.f1.ent  -anchor center -expand 1 -fill x -side right 
    pack $page.f2 -anchor center -expand 1 -fill x -side top 
    pack $page.f2.clear -anchor w -expand 0 -fill none -padx 5 -side left 

    set page [dialog:GetDialogFrame $this choice]
    $page.close configure  -command "main:DlgDispatch OnDestroyModeless"
    $page.run configure  -command "main:DlgDispatch OnRunTool"

    dialog:CenterDialog $this
    return $this
}

proc dialog-tool:OnRunTool {this} {
#--------------------------------------
    global dlgdata
    set id [main:GetWindowId $this]
    set page [dialog:GetDialogFrame $this info]
    set cmnd [$page.f0.ent get]
    set dir  [$page.f1.ent get]

    if {$cmnd == ""} {
        bell
        return
    }
#--- find or create Output window
    set fr_out [mdiclient:GetFrameByType "doc-text-output"]
    if {$fr_out == ""} {
        set fr_out [main:DoOpenFile "" "doc-text-output"]
    }
    set out_ch ""
    if {$fr_out != ""} {
        set out_ch [main:DocDispatch GetWriteChannel $fr_out $dlgdata($id,clear)]
    }
    if {$out_ch == ""} {
        return
    }
    
    set prev [pwd]
    if {$dir != ""} {
        if {[file isdirectory $dir]} {
            $out_ch insert end "cd $dir\n"
            cd $dir
        } else {
            bell
            return
        }
    }
    $out_ch insert end "$cmnd\n"
    set res [main:StartExternalProcess $out_ch true false "$cmnd"]
    if {$res != ""} {
        main:WaitExternalProcess
    }
    $out_ch see end
    cd $prev
}

proc dialog-tool:OnOK {this} {
#--------------------------------------
    dialog-tool:OnRunTool $this
}

proc dialog-entry:CreateDialog {parent title prompt} {
#------------------------------------------------------
    set this [dialog:CreateHorDialog $parent "dialog-entry" Cancel Ok]
    if {![winfo exists $this]} {
        return ""
    }
    wm geometry $this 250x100+335+249
    wm minsize $this 250 100
    wm title $this "$title"
    global dlgdata
    set id [main:GetWindowId $this]

    set page [dialog:GetDialogFrame $this info]
    frame  $page.f0 -borderwidth 1 -height 1 -relief flat -width 30 
    label  $page.f0.l -anchor w -relief flat -width 15 -text "$prompt"
    entry  $page.f0.ent -relief ridge -font [main:GetMainData font def]
    pack $page.f0 -anchor center -expand 1 -fill x -side top 
    pack $page.f0.l -anchor center -expand 0 -fill none -padx 5 -side left 
    pack $page.f0.ent  -anchor center -expand 1 -fill x -side right 

    dialog:CenterDialog $this
    return $this
}

proc dialog-entry:OnOK {this} {
#--------------------------------------
    set page [dialog:GetDialogFrame $this info]
    set ent [$page.f0.ent get]
    dialog:EndDialog $this "$ent"
}

proc dialog-entry:OnCancel {this} {
#--------------------------------------
    dialog:EndDialog $this ""
}
