##############################################################################
#    pvm
#    software development environment
#
#    Copyright (C) 1997  Andrew Guryanov
#    andrew-guryanov@usa.net
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
##############################################################################

#===========================================
#	Global variables
#===========================================

global mdiclient

set mdiclient(name) ""
set mdiclient(frame,maximized) 0
set mdiclient(frame,x) 0
set mdiclient(frame,y) 0
set mdiclient(frame,width) 0
set mdiclient(frame,height) 0
set mdiclient(frame,active) ""

set mdiclient(drag,op) "";
set mdiclient(drag,hittest) "";
set mdiclient(drag,att) 0
set mdiclient(drag,X) 0
set mdiclient(drag,Y) 0
set mdiclient(drag,left) 0
set mdiclient(drag,top)  0
set mdiclient(drag,width)  0
set mdiclient(drag,height)  0

set mdiclient(cursor,default) [. cget -cursor]


#===========================================
#	MDI client event handlers
#===========================================

proc mdiclient:OnWindowActivate {caption} {
#---------------------------------------------
    global mdiclient
    foreach fr_name [winfo children $mdiclient(name)] {
        set title [main:DocDispatch GetDocData $fr_name title]
        if {[string compare $title $caption] == 0} {
            mdiclient:ActivateFrame $fr_name
            return
        }
    }
}

proc mdiclient:OnWindowCascade {} {
#--------------------------------
    global mdiclient
    if {$mdiclient(frame,maximized)} {
        mdiclient:OnWindowMaximize
    }
	set par_width [winfo width $mdiclient(name)];
	set par_height [winfo height $mdiclient(name)];
    set fr_delta 30
    set fr_count 0
    foreach fr_name [winfo children $mdiclient(name)] {
        if {[winfo class $fr_name] == "Frame"} {
            set fr_width [expr $par_width/2]
            set fr_height [expr $par_height/2]
            set fr_x [expr ($fr_delta * $fr_count) % $fr_width]
            set fr_y [expr ($fr_delta * $fr_count) % $fr_height]
            place $fr_name -x $fr_x -y $fr_y -width $fr_width -height $fr_height -anchor nw -bordermode ignore 
            incr fr_count;
        }
    }
}

proc mdiclient:OnWindowTileHorizontal {} {
#-----------------------------------------
    global mdiclient
    if {$mdiclient(frame,maximized)} {
        mdiclient:OnWindowMaximize
    }
	set par_width [winfo width $mdiclient(name)];
	set par_height [winfo height $mdiclient(name)];
    set fr_count [mdiclient:GetFrameCount]
    if {$fr_count > 0} {
        set i 0
        set fr_height [expr $par_height/$fr_count]
        foreach fr_name [winfo children $mdiclient(name)] {
            if {[winfo class $fr_name] == "Frame"} {
                set fr_y [expr $i * $fr_height]
                incr i;
                if {$i == $fr_count} {
                    set fr_height [expr $par_height - $fr_y]
                }
                place $fr_name -x 0 -y $fr_y -width $par_width -height $fr_height
            }
        }
    }
}

proc mdiclient:OnWindowTileVertical {} {
#----------------------------------------
    global mdiclient
    if {$mdiclient(frame,maximized)} {
        mdiclient:OnWindowMaximize
    }
	set par_width [winfo width $mdiclient(name)];
	set par_height [winfo height $mdiclient(name)];
    set fr_count [mdiclient:GetFrameCount]
    if {$fr_count > 0} {
        set i 0
        set fr_width [expr $par_width/$fr_count]
        foreach fr_name [winfo children $mdiclient(name)] {
            if {[winfo class $fr_name] == "Frame"} {
                set fr_x [expr $i * $fr_width]
                incr i;
                if {$i == $fr_count} {
                    set fr_width [expr $par_width - $fr_x]
                }
                place $fr_name -x $fr_x -y 0 -width $fr_width -height $par_height
            }
        }
    }
}

proc mdiclient:OnWindowNext {} {
#---------------------------------------------
    global mdiclient
    if {$mdiclient(frame,active) != ""} {
        set fr_name [lindex [winfo children $mdiclient(name)] 0]
        if {$fr_name != $mdiclient(frame,active)} {
            mdiclient:ActivateFrame $fr_name
        }
    }
}

proc mdiclient:OnWindowPrev {} {
#---------------------------------------------
    global mdiclient
    if {$mdiclient(frame,active) != ""} {
        set lst [winfo children $mdiclient(name)]
        set len [llength $lst]
        if {$len > 1} {
            incr len -2
            set fr_name [lindex $lst $len]
            mdiclient:ActivateFrame $fr_name
        }
    }
}

proc mdiclient:OnWindowMaximize {} {
#------------------------------------
    global mdiclient
    if {$mdiclient(frame,maximized)} {
        set mdiclient(frame,maximized) 0
        if {[winfo exists $mdiclient(frame,active)]} {
            pack forget $mdiclient(frame,active)

# --- re-create caption
            $mdiclient(frame,active) configure -borderwidth 2
            if {![winfo exists $mdiclient(frame,active).caption]} {
                mdiclient:CreateFrameCaption $mdiclient(frame,active).caption
                mdiclient:BindFrameClient $mdiclient(frame,active)
            }
            $mdiclient(frame,active).caption.title configure \
            -bg [main:GetMainData color activebg] -fg [main:GetMainData color activefg]
            mdiclient:AdjustFrameName $mdiclient(frame,active)

            place $mdiclient(frame,active) -x $mdiclient(frame,x) -y $mdiclient(frame,y) \
                -width $mdiclient(frame,width) -height $mdiclient(frame,height) -anchor nw -bordermode ignore
        }
        set apptitle [main:GetMainData app title]
        wm title [main:GetMainData app frame] $apptitle
        set menuframe [main:GetMainData menu frame]
        destroy $menuframe.s
        destroy $menuframe.x
    } else {
        set mdiclient(frame,maximized) 1
        if {[winfo exists $mdiclient(frame,active)]} {
            set mdiclient(frame,x) [winfo x $mdiclient(frame,active)]
            set mdiclient(frame,y) [winfo y $mdiclient(frame,active)]
            set mdiclient(frame,width) [winfo width $mdiclient(frame,active)]
            set mdiclient(frame,height) [winfo height $mdiclient(frame,active)]

            place forget $mdiclient(frame,active)

            $mdiclient(frame,active) configure -borderwidth 0
            destroy $mdiclient(frame,active).caption
            mdiclient:AdjustFrameName $mdiclient(frame,active)

            pack $mdiclient(frame,active) -in $mdiclient(name) -expand 1 -fill both -anchor center -side top
        }
        set menuframe [main:GetMainData menu frame]
        button $menuframe.x -padx 6 -pady 0 -relief flat -borderwidth 1 -image mdiclient(frame,decoration,x) -command main:OnFileClose    
        button $menuframe.s -padx 6 -pady 0 -relief flat -borderwidth 1 -image mdiclient(frame,decoration,s) -command mdiclient:OnWindowMaximize
        bindtags $menuframe.x "btnPop [bindtags $menuframe.x]"
        bindtags $menuframe.s "btnPop [bindtags $menuframe.s]"
        pack $menuframe.x -anchor center -expand 0 -fill none -side right 
        pack $menuframe.s -anchor center -expand 0 -fill none -side right 
    }
}

proc mdiclient:OnEnterFrame {} {
#----------------------------------------
    global mdiclient;
    set mdiclient(drag,att) 1
    $mdiclient(frame,active) configure -cursor $mdiclient(cursor,default)
}

proc mdiclient:OnLeaveFrame {} {
#----------------------------------------
    global mdiclient;
    set mdiclient(drag,att) 0
    if {$mdiclient(drag,op) == ""} {
        set mdiclient(drag,hittest) "";
        $mdiclient(frame,active) configure -cursor $mdiclient(cursor,default)
    }
}

proc mdiclient:OnMouseMove {W X Y} {
#----------------------------------------
    global mdiclient;

    if {$mdiclient(drag,op) == "" && !$mdiclient(frame,maximized)} {
        mdiclient:CheckActiveBorder $mdiclient(frame,active) $X $Y
        return
    }

    set x_new  [expr  $X - $mdiclient(drag,X) + $mdiclient(drag,left)]
    set y_new  [expr  $Y - $mdiclient(drag,Y) + $mdiclient(drag,top)]
    set w_more [expr  $X - $mdiclient(drag,X) + $mdiclient(drag,width)]
    set w_less [expr -$X + $mdiclient(drag,X) + $mdiclient(drag,width)]
    set h_more [expr  $Y - $mdiclient(drag,Y) + $mdiclient(drag,height)]
    set h_less [expr -$Y + $mdiclient(drag,Y) + $mdiclient(drag,height)]

    switch $mdiclient(drag,op) {
    "default" {}
    "move"                { place $mdiclient(frame,active)  -x $x_new -y $y_new}
    "top_side"            { place $mdiclient(frame,active)  -y $y_new -height $h_less}
    "bottom_side"         { place $mdiclient(frame,active)  -height $h_more}
    "left_side"           { place $mdiclient(frame,active)  -x $x_new -width $w_less}
    "right_side"          { place $mdiclient(frame,active)  -width $w_more}
    "top_left_corner"     { place $mdiclient(frame,active)  -x $x_new -y $y_new -width $w_less -height $h_less}
    "bottom_right_corner" { place $mdiclient(frame,active)  -width $w_more -height $h_more}
    "top_right_corner"    { place $mdiclient(frame,active)  -y $y_new -width $w_more -height $h_less}
    "bottom_left_corner"  { place $mdiclient(frame,active)  -x $x_new -width $w_less -height $h_more}
    }
}

proc mdiclient:OnLeftDown {W X Y} {
#----------------------------------------
    global mdiclient;
    if {$mdiclient(drag,hittest) != ""} {
        mdiclient:BeginWindowDrag $mdiclient(drag,hittest) $mdiclient(frame,active) $X $Y
        return
    }
    set fr_name [mdiclient:GetDocFrame $W]
    if {$fr_name != ""} {
        mdiclient:ActivateFrame $fr_name
        mdiclient:OnEnterFrame
        if {[lindex [split $W .] 5] == "title" && !$mdiclient(frame,maximized)} {
            mdiclient:BeginWindowDrag "move" $fr_name $X $Y
        }
        return
    }
}

proc mdiclient:OnLeftRelease {W X Y} {
#----------------------------------------
    global mdiclient;
    if {$mdiclient(drag,op) != ""} {
        mdiclient:EndWindowDrag $mdiclient(frame,active)
    }
}

#===========================================
#	MDI client methods
#===========================================

proc mdiclient:GetDocFrame {W} {
#---------------------------------
    global mdiclient;
    while {1} {
        set parent [winfo parent $W]
        if {[string compare $parent $mdiclient(name)] == 0} {
            return $W
        }
        set W $parent
    }
    return ""
}

proc mdiclient:CreateWindow {this app_home} {
#-----------------------------------------
    global mdiclient
    set mdiclient(name) $this
    frame $this  -borderwidth 1 -height 30 -relief sunken -width 30 -bg [main:GetMainData color workspacebg]
    pack $this   -anchor center -expand 1 -fill both -side top 

    image create bitmap mdiclient(frame,decoration,x) -file $app_home/images/x.bmp
    image create bitmap mdiclient(frame,decoration,s) -file $app_home/images/s.bmp
}

proc mdiclient:GetFrameCount {} {
#----------------------------------
    global mdiclient
    set fr_count 0
    foreach fr_name [winfo children $mdiclient(name)] {
        if {[winfo class $fr_name] == "Frame"} {
            incr fr_count;
        }
    }
    return $fr_count
}

proc mdiclient:CreateNewFrame {fr_type} {
#-------------------------------------------
    global mdiclient;
    set fr_count [mdiclient:GetFrameCount]
	set par_width [winfo width $mdiclient(name)];
	set par_height [winfo height $mdiclient(name)];
    set fr_delta 30
    set fr_width [expr $par_width/2]
    set fr_height [expr $par_height/2]
    set fr_x [expr ($fr_delta * $fr_count) % $fr_width]
    set fr_y [expr ($fr_delta * $fr_count) % $fr_height]
    set fr_name $mdiclient(name).$fr_type

    frame $fr_name -borderwidth 2 -height 30 -relief sunken -width 30 
    place $fr_name -x $fr_x -y $fr_y -width $fr_width -height $fr_height -anchor nw -bordermode ignore 

    mdiclient:CreateFrameCaption $fr_name.caption
    main:DocDispatch OnCreateClient $fr_name
    main:DocDispatch OnChangeAppearance $fr_name
    mdiclient:BindFrameClient $fr_name
    return $fr_name
}

proc mdiclient:CreateFrameCaption {this} {
#--------------------------------------------
    global mdiclient;
    frame $this -borderwidth 1 -height 20 -relief sunken -width 30 
    label $this.title -anchor w -padx 10 -relief groove -font [main:GetMainData font caption]
    button $this.x -padx 6 -pady 0 -relief flat -borderwidth 1 -image mdiclient(frame,decoration,x) -command main:OnFileClose
    button $this.s -padx 6 -pady 0 -relief flat -borderwidth 1 -image mdiclient(frame,decoration,s) -command mdiclient:OnWindowMaximize
    bindtags $this.x "btnPop [bindtags $this.x]"
    bindtags $this.s "btnPop [bindtags $this.s]"
    pack $this.title -anchor center -expand 1 -fill x -side left 
    pack $this.x -anchor center -expand 0 -fill none -side right 
    pack $this.s -anchor center -expand 0 -fill none -side right 
    set other [lindex [pack slaves [winfo parent $this]] 0]
    if {$other != ""} {
        pack $this -before $other -anchor center -expand 0 -fill x -side top
    } else {
        pack $this -anchor center -expand 0 -fill x -side top
    }
}

proc mdiclient:BindFrameClient {this} {
#------------------------------------------
    foreach win [winfo children $this] {
        bind $win <Motion> {+mdiclient:OnMouseMove %W %X %Y}
        bind $win <Button-1> {+mdiclient:OnLeftDown %W %X %Y}
        bind $win <ButtonRelease-1> {+mdiclient:OnLeftRelease %W %X %Y}
        mdiclient:BindFrameClient $win
    }
}

proc mdiclient:AdjustFrameName {fr_name} {
#------------------------------------------
    global mdiclient;
    if {$fr_name == ""} {
        set fr_name $mdiclient(frame,active)
    }
    set caption [main:DocDispatch GetDocData $fr_name title]
    if {$mdiclient(frame,maximized)} {
        set apptitle "[main:GetMainData app title] - $caption"
        wm title [main:GetMainData app frame] $apptitle
    } else {
        if {[winfo exists $fr_name.caption.title]} {
            $fr_name.caption.title config -text $caption
        }
    }
}

proc mdiclient:DestroyActiveFrame {} {
#---------------------------------------
    global mdiclient;
    if {[winfo exists $mdiclient(frame,active)]} {
        mdiclient:OnLeaveFrame
        main:DocDispatch OnCloseDocument $mdiclient(frame,active)
        destroy $mdiclient(frame,active)
    }
    set mdiclient(frame,active) ""
    set lst [winfo children $mdiclient(name)]
    set len [llength $lst]
    for {incr len -1} {$len >=0} {incr len -1} {
        set fr_name [lindex $lst $len]
        if {[winfo class $fr_name] == "Frame"} {
            mdiclient:ActivateFrame $fr_name
            return true
        }
    }
    if {$mdiclient(frame,maximized)} {
        mdiclient:OnWindowMaximize
    }
    return false
}

proc mdiclient:ActivateFrame {fr_name} {
#---------------------------------------
    global mdiclient;
    set max_old $mdiclient(frame,maximized)
    set fr_old $mdiclient(frame,active)
    if {[string compare $fr_old $fr_name]} {
        if {[string length $fr_old]} {
            mdiclient:BindFrameEvents $fr_old 0
            $fr_old config -relief sunken
            if {$max_old} {
                mdiclient:OnWindowMaximize
            }
            if {[winfo exists $fr_old.caption.title]} {
                $fr_old.caption.title config \
                -bg [main:GetMainData color inactivebg] -fg [main:GetMainData color inactivefg]
            }
        }
        if {[winfo exists $fr_name]} {
            set mdiclient(frame,active) $fr_name
            if {$max_old} {
                mdiclient:OnWindowMaximize
                if {$fr_old == ""} {
                    mdiclient:OnWindowMaximize
                }
            }
            raise $fr_name
            if {[winfo exists $fr_name.caption.title]} {
                $fr_name.caption.title config \
                -bg [main:GetMainData color activebg] -fg [main:GetMainData color activefg]
            }
            $fr_name config -relief raised
            mdiclient:BindFrameEvents $fr_name 1
            mdiclient:ActivateClient $fr_name
        } else {
            set mdiclient(frame,active) ""
        }
    }
}

proc mdiclient:BindFrameEvents {this bind_on} {
#--------------------------------------------------
    if {$bind_on} {
        bind $this <Enter> {mdiclient:OnEnterFrame}
        bind $this <Leave> {mdiclient:OnLeaveFrame}
        bind $this <Motion> {mdiclient:OnMouseMove %W %X %Y}
        bind $this <Button-1> {mdiclient:OnLeftDown %W %X %Y}
        bind $this <ButtonRelease-1> {mdiclient:OnLeftRelease %W %X %Y}
    } else {
        bind $this <Enter> ""
        bind $this <Leave> ""
        bind $this <Motion> ""
        bind $this <Button-1> ""
        bind $this <ButtonRelease-1> ""
    }
}

proc mdiclient:ActivateClient {this} {
#-------------------------------------------------------
    foreach win [winfo children $this] {
        set classname [winfo class $win]
        if {$classname == "Text" || $classname == "Listbox"} {
            focus $win
            return 1
        }
        if {[mdiclient:ActivateClient $win]} {
            return 1
        }
    }
    return 0
}

proc mdiclient:GetActiveFrame {} {
#----------------------------------
    global mdiclient;
    return $mdiclient(frame,active)
}

proc mdiclient:GetFrameByType {type} {
#--------------------------------------
    global mdiclient
    foreach fr_name [winfo children $mdiclient(name)] {
        if {[winfo class $fr_name] == "Frame"} {
            if {[string compare [main:GetWindowType $fr_name] $type] == 0} {
                return $fr_name
            }
        }
    }
    return ""
}

proc mdiclient:GetFrameByPath {path} {
#--------------------------------------
    global mdiclient
    foreach fr_name [winfo children $mdiclient(name)] {
        if {[winfo class $fr_name] == "Frame"} {
            if {[string compare [main:DocDispatch GetDocData $fr_name path] $path] == 0} {
                return $fr_name
            }
        }
    }
    return ""
}

proc mdiclient:GrabSubtreeEvents {this dograb grabber} {
#-------------------------------------------------------
# all but caption
    foreach win [winfo children $this] {
        if {[lindex [split $win .] 4] != "caption"} {
            if {$dograb} {
                bindtags $win "$grabber"
            } else {
                bindtags $win "$win [winfo class $win] [main:GetMainData app frame] all"
            }
            mdiclient:GrabSubtreeEvents $win $dograb $grabber
        }
    }
}

proc mdiclient:BeginWindowDrag {drag_op Window X Y} {
#----------------------------------------------------
    global mdiclient;
    set mdiclient(drag,op) $drag_op
    set mdiclient(drag,X) $X
    set mdiclient(drag,Y) $Y
    set mdiclient(drag,left) [winfo x $Window]
    set mdiclient(drag,top)  [winfo y $Window]
    set mdiclient(drag,width)  [winfo width $Window]
    set mdiclient(drag,height)  [winfo height $Window]
    mdiclient:GrabSubtreeEvents $mdiclient(frame,active) 1 $mdiclient(frame,active)
    grab set $Window
}

proc mdiclient:EndWindowDrag {Window} {
#-------------------------------------------
    global mdiclient;
    set mdiclient(drag,op) "";
    set mdiclient(drag,hittest) "";
    $mdiclient(frame,active) configure -cursor $mdiclient(cursor,default)
    mdiclient:GrabSubtreeEvents $mdiclient(frame,active) 0 $mdiclient(frame,active)
    grab release $Window
}

proc mdiclient:CheckActiveBorder {W X Y} {
#----------------------------------------
    global mdiclient;
    if {$mdiclient(drag,att)} {
        set hittest [mdiclient:HitTestWindow $mdiclient(frame,active) $X $Y]
        if {$hittest != ""} {
            $mdiclient(frame,active) configure -cursor $hittest
        } else {
            if {$hittest != $mdiclient(drag,hittest)} {
                $mdiclient(frame,active) configure -cursor $mdiclient(cursor,default)
            }
        }
        set mdiclient(drag,hittest) $hittest
    }
}

proc mdiclient:HitTestWindow {W X Y} {
#----------------------------------------
    set left [winfo rootx $W]
    set top  [winfo rooty $W]
    set right [expr $left + [winfo width $W]]
    set bottom [expr $top + [winfo height $W]]
    set delta 2
    set offset 15
    if {$X >= $left && $X <= $right && $Y >= $top && $Y <= $bottom} {
        if {$X >= $left && $X <= [expr $left + $delta]} {
            if {$Y >= $top && $Y <= [expr $top + $offset]} {return "top_left_corner"}
            if {$Y >= [expr $bottom - $offset] && $Y <= $bottom} {return "bottom_left_corner"}
            return "left_side"
        }
        if {$X >= [expr $right - $delta] && $X <= $right} {
            if {$Y >= $top && $Y <= [expr $top + $offset]} {return "top_right_corner"}
            if {$Y >= [expr $bottom - $offset] && $Y <= $bottom} {return "bottom_right_corner"}
            return "right_side"
        }
        if {$Y >= $top && $Y <= [expr $top + $delta]} {
            if {$X >= $left && $X <= [expr $left + $offset]} {return "top_left_corner"}
            if {$X >= [expr $right - $offset] && $X <= $right} {return "top_right_corner"}
            return "top_side"
        }
        if {$Y >= [expr $bottom - $delta] && $Y <= $bottom} {
            if {$X >= $left && $X <= [expr $left + $offset]} {return "bottom_left_corner"}
            if {$X >= [expr $right - $offset] && $X <= $right} {return "bottom_right_corner"}
            return "bottom_side"
        }
    }
    return "";
}

proc mdiclient:ConfigureFrameAppearance {} {
#------------------------------------------------------
    global mdiclient
    $mdiclient(name) configure -bg [main:GetMainData color workspacebg]

    foreach fr_name [winfo children $mdiclient(name)] {
        if {[winfo exists $fr_name.caption.title]} {
            $fr_name.caption.title configure -font [main:GetMainData font caption] \
                -bg [main:GetMainData color inactivebg] -fg [main:GetMainData color inactivefg]
        }
        main:DocDispatch OnChangeAppearance $fr_name
    }
    if {$mdiclient(frame,active) != ""} {
        if {[winfo exists $fr_name.caption.title]} {
            $fr_name.caption.title configure \
                -bg [main:GetMainData color activebg] -fg [main:GetMainData color activefg]
        }
    }
}

proc mdiclient:SaveAllModified {{query 1}} {
#---------------------------------------
    global mdiclient
    foreach fr_name [winfo children $mdiclient(name)] {
        set ret [main:DocDispatch SaveIfModified $fr_name $query]
        if {$ret == "false"} {
            return $ret
        }
    }
    return true
}
